-- Filename: waves_device_alu.vhd
--
-- Version 2.1
--
-----------------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is
  type Test_Pins is ( TP_RBUS3, TP_RBUS2, TP_RBUS1, TP_RBUS0,
                      TP_SBUS3, TP_SBUS2, TP_SBUS1, TP_SBUS0,
                      TP_FBUS3, TP_FBUS2, TP_FBUS1, TP_FBUS0, 
                      TP_FUNT2, TP_FUNT1, TP_FUNT0, TP_CIN,
                      TP_G, TP_P, TP_CO, TP_F3, TP_OVR, TP_F);

  constant DEVICE_ID : String := "alu";

  -- The following declaration is just for documentation purposes.
  constant PIN_DIRECTION : Direction_List := (Stimulus,   -- TP_RBUS3
                                              Stimulus,   -- TP_RBUS2
                                              Stimulus,   -- TP_RBUS1
                                              Stimulus,   -- TP_RBUS0
                                              Stimulus,   -- TP_SBUS3
                                              Stimulus,   -- TP_SBUS2
                                              Stimulus,   -- TP_SBUS1
                                              Stimulus,   -- TP_SBUS0
                                              Response,   -- TP_FBUS3
                                              Response,   -- TP_FBUS2
                                              Response,   -- TP_FBUS1
                                              Response,   -- TP_FBUS0
                                              Stimulus,   -- TP_FUNT2
                                              Stimulus,   -- TP_FUNT1
                                              Stimulus,   -- TP_FUNT0
                                              Stimulus,   -- TP_CIN
                                              Response,   -- TP_G
                                              Response,   -- TP_P
                                              Response,   -- TP_CO
                                              Response,   -- TP_F3
                                              Response,   -- TP_OVR
                                              Response);  -- TP_F
        
  function PIN_NAME (PIN : Test_Pins) return string;
    
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return string is
  begin
    case PIN is
      when TP_RBUS3 => return "RBUS3";
      when TP_RBUS2 => return "RBUS2";
      when TP_RBUS1 => return "RBUS1";
      when TP_RBUS0 => return "RBUS0";
      when TP_SBUS3 => return "SBUS3";
      when TP_SBUS2 => return "SBUS2";
      when TP_SBUS1 => return "SBUS1";
      when TP_SBUS0 => return "SBUS0";
      when TP_FBUS3 => return "FBUS3";
      when TP_FBUS2 => return "FBUS2";
      when TP_FBUS1 => return "FBUS1";
      when TP_FBUS0 => return "FBUS0";
      when TP_FUNT2 => return "FUNT2";
      when TP_FUNT1 => return "FUNT1";
      when TP_FUNT0 => return "FUNT0";
      when TP_CIN   => return "CIN";
      when TP_G     => return "G";
      when TP_P     => return "P";
      when TP_CO    => return "CO";
      when TP_F3    => return "F3";
      when TP_OVR   => return "OVR";
      when TP_F     => return "F";
    end case;
  end;

end WAVES_DEVICE;

