--  Filename: alu_TB.vhd
--
-- Version 2.1
--
-----------------------------------------------------------------------------

library IEEE;                   -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library AM29C01_PACKAGE;
  use AM29C01_PACKAGE.TYPES.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library ALU;
  use ALU.WAVES_DEVICE.all;
  use ALU.WAVES_OBJECTS.all;
  use ALU.WGENERATOR_alu.all;
  use ALU.WAVES_UTILITIES.all;

entity alu_TB is

  begin
  
  end alu_TB;

-- ======================================================================

architecture TEST_BENCH of alu_TB is

  component DUT 
    port 
    (
      RBUS : in  Fourbit;
      SBUS : in  Fourbit; 
      FBUS : out Fourbit;
      FUNT : in  Threebit;
      CIN  : in  Std_Ulogic;
      G    : out Std_Ulogic;
      P    : out Std_Ulogic;
      CO   : out Std_Ulogic;
      F3   : out Std_Ulogic;
      OVR  : out Std_Ulogic;
      F    : out Std_Ulogic
    );
  end component;

  for all : DUT use entity ALU.ALU(BEHAVIORAL);

  subtype Test_Pin_Range is integer range
      Test_Pins'pos(TP_RBUS3) + 1 to Test_Pins'pos(TP_F) + 1;

  -- Input and Output traffic of DUT
  signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  signal RBUS : Fourbit;
  signal SBUS : Fourbit;
  signal FBUS : Fourbit;
  signal FUNT : Threebit;

  -- Test program options
  constant IN_FILE_NAME        : String := "alu_in.dat";
  constant START_TOLERANCE     : Time   := 0 ns;
  constant END_TOLERANCE       : Time   := 0 ns;
  constant DEFAULT_PERIOD      : Time   := 5 ns;
  constant DEFAULT_UNCERTAINTY : Real   := 0.95;

  -- Comparator options
  signal COMPARE           : Boolean           := TRUE;
  constant HOW_TO_REPORT   : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level    := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := STANDARD;
  constant OUT_FILE_NAME : String        := "alu_out.dat";

--signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) := (others.M_VALUE => TRUE);
  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES dataset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range1 is Integer range
      Test_Pins'pos(TP_FBUS3) + 1 to Test_Pins'pos(TP_FBUS0) + 1;

  subtype Compare_Pin_Range2 is integer range
      Test_Pins'pos(TP_G) + 1 to Test_Pins'pos(TP_F) + 1;

------------------------------------------------------------------------------

begin

  -- Call the waveform generator (i.e., the WAVES dataset)
  process begin
--  alu_TEST(CONNECT);
    alu_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE);
--  alu_TEST(CONNECT, IN_FILE_NAME, DEFAULT_PERIOD, DEFAULT_UNCERTAINTY);
    wait;
  end process;

  ----------------------------------------------------------------------------
  -- Instantiate the Device under test

  RBUS(3) <= TRAFFIC(Test_Pins'Pos(TP_RBUS3) + 1);
  RBUS(2) <= TRAFFIC(Test_Pins'Pos(TP_RBUS2) + 1);
  RBUS(1) <= TRAFFIC(Test_Pins'Pos(TP_RBUS1) + 1);
  RBUS(0) <= TRAFFIC(Test_Pins'Pos(TP_RBUS0) + 1);

  SBUS(3) <= TRAFFIC(Test_Pins'Pos(TP_SBUS3) + 1);
  SBUS(2) <= TRAFFIC(Test_Pins'Pos(TP_SBUS2) + 1);
  SBUS(1) <= TRAFFIC(Test_Pins'Pos(TP_SBUS1) + 1);
  SBUS(0) <= TRAFFIC(Test_Pins'Pos(TP_SBUS0) + 1);
  
  FUNT(2) <= TRAFFIC(Test_Pins'Pos(TP_FUNT2) + 1);
  FUNT(1) <= TRAFFIC(Test_Pins'Pos(TP_FUNT1) + 1);
  FUNT(0) <= TRAFFIC(Test_Pins'Pos(TP_FUNT0) + 1);

  TRAFFIC(Test_Pins'Pos(TP_FBUS3) + 1) <= FBUS(3);
  TRAFFIC(Test_Pins'Pos(TP_FBUS2) + 1) <= FBUS(2);
  TRAFFIC(Test_Pins'Pos(TP_FBUS1) + 1) <= FBUS(1);
  TRAFFIC(Test_Pins'Pos(TP_FBUS0) + 1) <= FBUS(0);


  UNDER_TEST : DUT
    port map 
    (
      RBUS,
      SBUS,
      FBUS,
      FUNT,
      TRAFFIC(Test_Pins'Pos(TP_CIN) + 1),
      TRAFFIC(Test_Pins'Pos(TP_G) + 1),
      TRAFFIC(Test_Pins'Pos(TP_P) + 1),
      TRAFFIC(Test_Pins'Pos(TP_CO) + 1),
      TRAFFIC(Test_Pins'Pos(TP_F3) + 1),
      TRAFFIC(Test_Pins'Pos(TP_OVR) + 1),
      TRAFFIC(Test_Pins'Pos(TP_F) + 1)
    );

  ----------------------------------------------------------------------------
  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

  COLLECT_INPUTS1:
    for I in Test_Pins'pos(TP_Rbus3) + 1 to Test_Pins'pos(TP_Sbus0) + 1 generate
        TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
        (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS1;

  COLLECT_INPUTS2:
    for I in Test_Pins'pos(TP_Funt2) + 1 to Test_Pins'pos(TP_Cin) + 1 generate
        TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
        (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS2;

----------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT);

----------------------------------------------------------------------------

  GEN_COMPARATOR1:
    for I in Compare_Pin_Range1 generate
      COMPARATOR : CHECK_RESPONSE(WHICH_ONE => I, RESPONSE => TRAFFIC(I),
                                  PREDICTION => CONNECT(I), COMPARE => COMPARE,
                                  HOW_TO_REPORT => HOW_TO_REPORT,
                                  ASSERTION_LEVEL => ASSERTION_LEVEL,
                                  MATCH => SMATCH(I).M_VALUE );

  end generate GEN_COMPARATOR1;

  GEN_COMPARATOR2:
    for I in Compare_Pin_Range2 generate
      COMPARATOR : CHECK_RESPONSE(WHICH_ONE => I, RESPONSE => TRAFFIC(I),
                                  PREDICTION => CONNECT(I), COMPARE => COMPARE,
                                  HOW_TO_REPORT => HOW_TO_REPORT,
                                  ASSERTION_LEVEL => ASSERTION_LEVEL,
                                  MATCH => SMATCH(I).M_VALUE );

  end generate GEN_COMPARATOR2;

end TEST_BENCH;

