-- FILE NAME:        waves_device_Am29C01.vhd
--
--                                   DISCLAIMER
--
--        This code is the sole property of the Institute for Technology
--        Development (ITD), Jackson, Mississippi, and is distributed for
--        the purpose of providing examples of VHDL models written to
--        modeling standards.  This code may not be used for commercial
--        purposes, and may not be redistributed without permission from
--        the Institute for Technology Development.  ITD assumes no 
--        responsibility for errors, omissions, uses made, or decisions
--        based on its use.  No warranties, expressed or implied, are given.
--
--        This is a modified IEEE WAVES package.  It was written specifically
--        to describe the test pins of the model being tested.
--
--        ------------------------------------------------------------------
library WAVES_STANDARD ;
use WAVES_STANDARD.WAVES_STANDARD.all ;

package WAVES_DEVICE is

    type Test_Pins is ( TP_Y3, TP_Y2, TP_Y1, TP_Y0,
                        TP_Co, TP_G, TP_P, TP_OVR, TP_F, TP_F3,
                        TP_Q3, TP_Ram3, TP_Q0, TP_Ram0,
                        TP_A3, TP_A2, TP_A1, TP_A0,
                        TP_B3, TP_B2, TP_B1, TP_B0,
                        TP_D3, TP_D2, TP_D1, TP_D0,
                        TP_Cn, TP_I2, TP_I1, TP_I0,
                        TP_I8, TP_I7, TP_I6,
                        TP_I5, TP_I4, TP_I3,
                        TP_OE, TP_CP) ;

    constant DEVICE_ID : string := "Am29C01" ;

  -- The following declaration is just for documentation purposes.

    constant PIN_DIRECTION : Direction_List := (Response,   -- TP_Y0
                                                Response,   -- TP_Y1
                                                Response,   -- TP_Y2
                                                Response,   -- TP_Y3
                                                Response,   -- TP_Co
                                                Response,   -- TP_G
                                                Response,   -- TP_P
                                                Response,   -- TP_OVR
                                                Response,   -- TP_F
                                                Response,   -- TP_F3
                                                Stimulus,   -- TP_Q3
                                                Stimulus,   -- TP_Ram3
                                                Stimulus,   -- TP_Q0
                                                Stimulus,   -- TP_Ram0
                                                Stimulus,   -- TP_A0
                                                Stimulus,   -- TP_A1
                                                Stimulus,   -- TP_A2
                                                Stimulus,   -- TP_A3
                                                Stimulus,   -- TP_B0
                                                Stimulus,   -- TP_B1
                                                Stimulus,   -- TP_B2
                                                Stimulus,   -- TP_B3
                                                Stimulus,   -- TP_D0
                                                Stimulus,   -- TP_D1
                                                Stimulus,   -- TP_D2
                                                Stimulus,   -- TP_D3
                                                Stimulus,   -- TP_Cn
                                                Stimulus,   -- TP_I0
                                                Stimulus,   -- TP_I1
                                                Stimulus,   -- TP_I2
                                                Stimulus,   -- TP_I6
                                                Stimulus,   -- TP_I7
                                                Stimulus,   -- TP_I8
                                                Stimulus,   -- TP_I3
                                                Stimulus,   -- TP_I4
                                                Stimulus,   -- TP_I5
                                                Stimulus,   -- TP_OE
                                                Stimulus) ; -- TP_CP
        
    function PIN_NAME (PIN : Test_Pins) return string ;

end WAVES_DEVICE ;

-- ======================================================================

package body WAVES_DEVICE is

    function PIN_NAME (PIN : Test_Pins) return string is
    begin
        case PIN is
            when TP_Y0 => return "Y0" ;
            when TP_Y1 => return "Y1" ;
            when TP_Y2 => return "Y2" ;
            when TP_Y3 => return "Y3" ;
            when TP_Co => return "Co" ;
            when TP_G => return "G" ;
            when TP_P => return "P" ;
            when TP_OVR => return "OVR" ;
            when TP_F => return "F" ;
            when TP_F3 => return "F3" ;
            when TP_Q3 => return "Q3" ;
            when TP_Ram3 => return "Ram3" ;
            when TP_Q0 => return "Q0" ;
            when TP_Ram0 => return "Ram0" ;
            when TP_A0 => return "A0" ;
            when TP_A1 => return "A1" ;
            when TP_A2 => return "A2" ;
            when TP_A3 => return "A3" ;
            when TP_B0 => return "B0" ;
            when TP_B1 => return "B1" ;
            when TP_B2 => return "B2" ;
            when TP_B3 => return "B3" ;
            when TP_D0 => return "D0" ;
            when TP_D1 => return "D1" ;
            when TP_D2 => return "D2" ;
            when TP_D3 => return "D3" ;
            when TP_Cn => return "Cn" ;
            when TP_I0 => return "I0" ;
            when TP_I1 => return "I1" ;
            when TP_I2 => return "I2" ;
            when TP_I6 => return "I6" ;
            when TP_I7 => return "I7" ;
            when TP_I8 => return "I8" ;
            when TP_I3 => return "I3" ;
            when TP_I4 => return "I4" ;
            when TP_I5 => return "I5" ;
            when TP_OE => return "OE" ;
            when TP_CP => return "CP" ;
        end case ;
    end ;

end WAVES_DEVICE ;

