--        Filename : Am29C01_con.vhd
--
--                                   DISCLAIMER
--
--        This code is the sole property of the Institute for Technology
--        Development (ITD), Jackson, Mississippi, and is distributed for
--        the purpose of providing examples of VHDL models written to
--        modeling standards.  This code may not be used for commercial
--        purposes, and may not be redistributed without permission from
--        the Institute for Technology Development.  ITD assumes no
--        responsibility for errors, omissions, uses made, or decisions
--        based on its use.  No warranties, expressed or implied, are given.
--
--        ------------------------------------------------------------------

Library ALU, DECODER, LATCH, QREG, RAM, RMUX, SHIFTER, SMUX, TS_BUFFER, YMUX;

-- This Configuration specification establishes which leaf 
-- modules (entity and architecture) will be used for the
-- structural entity of the Am29C01.

configuration Am29C01_con of Am29C01 is
   for structural
      for ALU1 : inst_alu
        use entity alu.alu(Behavioral) ;
      end for ;

      for decoder1 : inst_decode
        use entity decoder.decoder(Behavioral) ;
      end for ;

      for latchR : inst_latch 
        use entity latch.latch(Behavioral) ;
      end for ;

      for latchS : inst_latch 
        use entity latch.latch(Behavioral) ;
      end for ;

      for qreg1 : inst_qreg
        use entity qreg.qreg(Behavioral) ;
      end for ;

      for ram1 : inst_ram 
        use entity ram.ram(Behavioral) ;
      end for ;

      for rmux1 : inst_mux3to1
        use entity rmux.rmux(Behavioral) ;
      end for ;

      for ramshift1 : inst_shifter
         use entity shifter.shifter(Behavioral) ; 
      end for ;

      for qshift1 : inst_shifter
         use entity shifter.shifter(Behavioral) ;
      end for ;

      for smux1 : inst_mux4to1 
         use entity smux.smux(Behavioral) ;
      end for ;

      for qmux1 : inst_mux2to1
         use entity ymux.ymux(Behavioral) ;
      end for ;

      for ymux1 : inst_mux2to1
         use entity ymux.ymux(Behavioral) ;
      end for ;

      for ts_buffer1 : inst_ts_buffer
         use entity ts_buffer.ts_buffer(Behavioral) ;
      end for ;

   end for ;

end Am29C01_con ;                                             
