--  File name:        Am29C01_TB.vhd

library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library WAVES_STANDARD ;
  use WAVES_STANDARD.WAVES_INTERFACE.all ;

library Am29C01;
  use Am29C01.WAVES_DEVICE.all ;
  use Am29C01.WAVES_OBJECTS.all ;
  use Am29C01.WAVES_UTILITIES.all ;
  use Am29C01.WGENERATOR_Am29C01.all ;

entity Am29C01_TB is
  begin
  end Am29C01_TB ;

-- ======================================================================

architecture TEST_BENCH of Am29C01_TB is

    component DUT 
      port (Y0, Y1, Y2, Y3 : out std_ulogic := 'U' ;
            Co             : out std_ulogic := 'U' ;
            G              : out std_ulogic := 'U' ;
            P              : out std_ulogic := 'U' ;
            OVR            : out std_ulogic := 'U' ;
            F              : out std_ulogic := 'U' ;
            F3             : out std_ulogic := 'U' ;
            Q3             : inout std_logic := 'U' ;
            Ram3           : inout std_logic := 'U' ;
            Q0             : inout std_logic := 'U' ;
            Ram0           : inout std_logic := 'U' ;
            A0, A1, A2, A3 : in std_ulogic := 'U' ;
            B0, B1, B2, B3 : in std_ulogic := 'U' ;
            D0, D1, D2, D3 : in std_ulogic := 'U' ;
            Cn             : in std_ulogic := 'U' ;
            I0, I1, I2     : in std_ulogic := 'U' ;
            I6, I7, I8     : in std_ulogic := 'U' ;
            I3, I4, I5     : in std_ulogic := 'U' ;
            OE             : in std_ulogic := 'U' ;
            CP             : in std_ulogic := 'U') ;
    end component ;

    for all : DUT use configuration WORK.Am29C01_con;

    subtype Test_Pin_Range is integer range
        Test_Pins'pos(TP_Y3) + 1 to Test_Pins'pos(TP_CP) + 1;

  -- Input and Output traffic of DUT
    signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range) ;

    signal INOUT_VECTOR : std_logic_vector(1 to 4);
    constant displacement : integer := Test_Pins'POS(TP_Q3);

  -- Test program options
    constant IN_FILE_NAME : string := "Am29C01_waves.dat" ;
    constant START_TOLERANCE : time := 5 ns ;
    constant END_TOLERANCE : time := 10 ns ;
    constant DEFAULT_PERIOD : time := 50 ns ;
    constant DEFAULT_UNCERTAINTY : real := 0.95 ;

  -- Comparator options
    signal COMPARE : boolean := true ;
    constant HOW_TO_REPORT : Comparison_Format := DO_ASSERTION ;
    constant ASSERTION_LEVEL : Severity_Level := WARNING ;

  -- Signal monitor options
    constant HOW_TO_PRINT : Output_Format := STANDARD ;
    constant OUT_FILE_NAME : string := "Am29C01_out.dat" ;

--    signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) := (others.M_VALUE => TRUE) ;
    signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) ;

  -- Connection to WAVES dataset
    signal CONNECT : Waves_Port_List (Test_Pin_Range) ;

    subtype Compare_Pin_Range is integer range
        Test_Pins'pos(TP_Y3) + 1 to Test_Pins'pos(TP_Ram0) + 1;

------------------------------------------------------------------------------

begin

    -- Call the waveform generator (i.e., the WAVES dataset)
    process begin
--      Am29C01_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE) ;
--      Am29C01_TEST(CONNECT) ;
      Am29C01_TEST(CONNECT, IN_FILE_NAME, DEFAULT_PERIOD, DEFAULT_UNCERTAINTY) ;
      wait ;
    end process ;

  ----------------------------------------------------------------------------
    -- Instantiate the Device under test

    Assign_Inouts:
        for I in Test_Pins'Pos(TP_Q3) + 1 to Test_Pins'Pos(TP_Ram0) + 1 generate
            INOUT_VECTOR(I - DISPLACEMENT) <= LOGIC_VALUE_TO_STD_ULOGIC
                                             (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I))) ;
        end generate Assign_Inouts ;

    UNDER_TEST : DUT
    port map (
        TRAFFIC(Test_Pins'Pos(TP_Y0) + 1),
        TRAFFIC(Test_Pins'Pos(TP_Y1) + 1),
        TRAFFIC(Test_Pins'Pos(TP_Y2) + 1),
        TRAFFIC(Test_Pins'Pos(TP_Y3) + 1),
        TRAFFIC(Test_Pins'Pos(TP_Co) + 1),
        TRAFFIC(Test_Pins'Pos(TP_G) + 1),
        TRAFFIC(Test_Pins'Pos(TP_P) + 1),
        TRAFFIC(Test_Pins'Pos(TP_OVR) + 1),
        TRAFFIC(Test_Pins'Pos(TP_F) + 1),
        TRAFFIC(Test_Pins'Pos(TP_F3) + 1),

        INOUT_VECTOR(1),    --(Test_Pins'Pos(TP_Q3 - DISPLACEMENT) + 1),
        INOUT_VECTOR(2),    --(Test_Pins'Pos(TP_Ram3 - DISPLACEMENT) + 1),
        INOUT_VECTOR(3),    --(Test_Pins'Pos(TP_Q0 - DISPLACEMENT) + 1),
        INOUT_VECTOR(4),    --(Test_Pins'Pos(TP_Ram0 - DISPLACEMENT) + 1),

        TRAFFIC(Test_Pins'Pos(TP_A0) + 1),
        TRAFFIC(Test_Pins'Pos(TP_A1) + 1),
        TRAFFIC(Test_Pins'Pos(TP_A2) + 1),
        TRAFFIC(Test_Pins'Pos(TP_A3) + 1),
        TRAFFIC(Test_Pins'Pos(TP_B0) + 1),
        TRAFFIC(Test_Pins'Pos(TP_B1) + 1),
        TRAFFIC(Test_Pins'Pos(TP_B2) + 1),
        TRAFFIC(Test_Pins'Pos(TP_B3) + 1),
        TRAFFIC(Test_Pins'Pos(TP_D0) + 1),
        TRAFFIC(Test_Pins'Pos(TP_D1) + 1),
        TRAFFIC(Test_Pins'Pos(TP_D2) + 1),
        TRAFFIC(Test_Pins'Pos(TP_D3) + 1),
        TRAFFIC(Test_Pins'Pos(TP_Cn) + 1),
        TRAFFIC(Test_Pins'Pos(TP_I0) + 1),
        TRAFFIC(Test_Pins'Pos(TP_I1) + 1),
        TRAFFIC(Test_Pins'Pos(TP_I2) + 1),
        TRAFFIC(Test_Pins'Pos(TP_I6) + 1),
        TRAFFIC(Test_Pins'Pos(TP_I7) + 1),
        TRAFFIC(Test_Pins'Pos(TP_I8) + 1),
        TRAFFIC(Test_Pins'Pos(TP_I3) + 1),
        TRAFFIC(Test_Pins'Pos(TP_I4) + 1),
        TRAFFIC(Test_Pins'Pos(TP_I5) + 1),
        TRAFFIC(Test_Pins'Pos(TP_OE) + 1),
        TRAFFIC(Test_Pins'Pos(TP_CP) + 1)
    ) ;
    
    
  ----------------------------------------------------------------------------
    -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

    COLLECT_INPUTS:
    for I in Test_Pins'pos(TP_A3) + 1 to Test_Pins'pos(TP_CP) + 1 generate
                TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
                        (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I))) ;
    end generate COLLECT_INPUTS ;

    COLLECT_INOUTS:
    for I in Test_Pins'pos(TP_Q3) + 1 to Test_Pins'pos(TP_Ram0) + 1 generate
                TRAFFIC(I) <= INOUT_VECTOR(I - DISPLACEMENT) ;
    end generate COLLECT_INOUTS ;

  ----------------------------------------------------------------------------

    SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT) ;

  ----------------------------------------------------------------------------

    GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE(
        WHICH_ONE => I,
        RESPONSE => TRAFFIC(I),
        PREDICTION => CONNECT(I),
        COMPARE => COMPARE,
        HOW_TO_REPORT => HOW_TO_REPORT,
        ASSERTION_LEVEL => ASSERTION_LEVEL,
        MATCH => SMATCH(I).M_VALUE ) ;

    end generate GEN_COMPARATOR ;

end TEST_BENCH ;

