--        Filename : Am29C01.vhd
--        Version 2.1
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants
--      that it will not decompile, disassemble or reverse engineer the
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--
--        ------------------------------------------------------------------
--
-- Part Name :        Am29C01
-- Manufacturer :     Advanced Micro-Devices (AMD)
-- Refernce :         Bipolar Microprocessor Logic and Interface - 1985
-- Packaging :        
-- Description :      The Am29C01 four-bit bipolar microprocessor slice is a 
--                    cascadable ALU intended for use in CPUs, periphal 
--                    controllers, and programmable microprocessors. The
--                    device consist of a 16-word by 4-bit two-port RAM,
--                    an 8-function ALU with associated shifting, decoding,
--                    and multiplexing circuitry.
--
-- Developer:          Institute for Technology Development
--                     VHDL Modeling Group
--                     1 Research Boulevard, Suite 205
--                     Starkville, MS 39759
--
-- Contact:            Dan Johnson
--                     CAD Section Manager
--                     (601) 325-2240
--                     danj@itd.msstate.edu
--
-- Version             2.1
-- Date:               07-12-91
--
-- Date of Formal
-- Verification:       TBD
--
--
-- Applicable Files (Listed in order of analysis): 

--   IEEE/std_logic_1164.pkg.vhd  -- 9-state logic system

--   STD_PACK/MISC_FUNC.vhd       -- miscellaneous functions
--   STD_PACK/TIME_FUNC.vhd       -- timing functions
--   STD_PACK/SIMFLAG_.vhd        -- simulation flag declarations
--   STD_PACK/SIMFLAG.vhd         -- simulation flag assignments
--   STD_PACK/TTL_TIMING.vhd      -- environmental derating coefficients
--
--   STD_WAVES/STANDARD/waves_system.vhd    -- describes Event Value objects
--   STD_WAVES/STANDARD/waves_standard.vhd  -- basic WAVES definition
--   STD_WAVES/LOCAL/waves_events.vhd       -- links events to logic values
--   STD_WAVES/STANDARD/waves_interface.vhd -- defines functions for application of
--                                             input values and file input of vectors
--
--   types.vhd          -- local types for Am29C01
--   functions.vhd      -- local functions for Am29C01
--
--   alu.vhd            -- entity/architecture for the ALU
--   latch.vhd          -- entity/architecture for 4-bit latch
--   rmux.vhd           -- entity/architecture for 3to1 mux
--   smux.vhd           -- entity/architecture for 4to1 mux
--   ymux.vhd           -- entity/architecture for 2to1 mux
--   decode.vhd         -- entity/architecture for instruction decoder
--   ts_buffer.vhd      -- entity/architecture for tri-state buffer
--   shifter.vhd        -- entity/architecture for 4-bit shifter
--   qreg.vhd           -- entity/architecture for 4-bit register
--   ram.vhd            -- entity/architecture for 16x4 ram
--
--   waves_device_Am29C01.vhd               -- test pins packagte
--   STD_WAVES/LOCAL/waves_frames.vhd       -- links event values to pin codes
--   STD_WAVES/STANDARD/waves_objects.vhd   -- defines functions that create slices
--   STD_WAVES/LOCAL/waves_utilities.vhd    -- defines functions to check responses
--                                             and to output port values to a file
--   wgenerator_Am29C01.vhd     -- WAVES test package
--   Am29C01.vhd                -- structural entity/architecture
--   Am29C01_TB.vhd             -- WAVES test bench entity/architecture
--   Am29C01_con.vhd            -- configuration file for top-level architecture             
--
------------------------------------------------------------------------------

library IEEE;
  use IEEE.STD_LOGIC_1164.all;       -- Defines logic types, operators, functions

library AM29C01_PACKAGE;
  use Am29C01_PACKAGE.TYPES.all;
  use Am29C01_PACKAGE.FUNCTIONS.all;

entity Am29C01 is
   
  port(
    Y0, Y1, Y2, Y3 : out Std_Ulogic := 'U';    -- the four tristate data output lines
    CO             : out Std_Ulogic := 'U';    -- the carry out of internal ALU
    G              : out Std_Ulogic := 'U';    -- the carry generate from ALU
    P              : out Std_Ulogic := 'U';    -- the carry propogate from ALU
    OVR            : out Std_Ulogic := 'U';    -- The overflow output from ALU
    F              : out Std_Ulogic := 'U';    -- the output which indicates if ALU op = 0
    F3             : out Std_Ulogic := 'U';    -- the msb ALU output bit
    Q3             : inout Std_Logic := 'U';  -- the shift line at msb of the Q register
    RAM3           : inout Std_Logic := 'U';  -- the shift line at msb of ram
    Q0             : inout Std_Logic := 'U';  -- the shift line at lsb of Q register
    RAM0           : inout Std_Logic := 'U';  -- the shift line at lsb of Ram
    A0, A1, A2, A3 : in Std_Ulogic := 'U';     -- A address inputs
    B0, B1, B2, B3 : in Std_Ulogic := 'U';     -- B address inputs
    D0, D1, D2, D3 : in Std_Ulogic := 'U';     -- direct data inputs
    Cn             : in Std_Ulogic := 'U';     -- carry in to ALU
    I0, I1, I2     : in Std_Ulogic := 'U';     -- inst. lines for ALU data source
    I6, I7, I8     : in Std_Ulogic := 'U';     -- inst. lines for ALU destination
    I3, I4, I5     : in Std_Ulogic := 'U';     -- inst. lines for ALU operation
    OE             : in Std_Ulogic := 'U';     -- output enable for Y outputs
    CP             : in Std_Ulogic := 'U'       -- the clock input
  );
   
   -- PIN MAPPING
   
   attribute PIN_NO : positive;
   attribute PIN_NO of A3   : signal is 1;
   attribute PIN_NO of A2   : signal is 2;
   attribute PIN_NO of A1   : signal is 3;
   attribute PIN_NO of A0   : signal is 4;
   attribute PIN_NO of I6   : signal is 5;
   attribute PIN_NO of I8   : signal is 6;
   attribute PIN_NO of I7   : signal is 7;
   attribute PIN_NO of RAM3 : signal is 8;
   attribute PIN_NO of RAM0 : signal is 9;
   attribute PIN_NO of F    : signal is 11;
   attribute PIN_NO of I0   : signal is 12;
   attribute PIN_NO of I1   : signal is 13;
   attribute PIN_NO of I2   : signal is 14;
   attribute PIN_NO of CP   : signal is 15;
   attribute PIN_NO of Q3   : signal is 16;
   attribute PIN_NO of B0   : signal is 17;
   attribute PIN_NO of B1   : signal is 18;
   attribute PIN_NO of B2   : signal is 19;
   attribute PIN_NO of B3   : signal is 20;
   attribute PIN_NO of Q0   : signal is 21;
   attribute PIN_NO of D3   : signal is 22;
   attribute PIN_NO of D2   : signal is 23;
   attribute PIN_NO of D1   : signal is 24;
   attribute PIN_NO of D0   : signal is 25;
   attribute PIN_NO of I3   : signal is 26;
   attribute PIN_NO of I5   : signal is 27;
   attribute PIN_NO of I4   : signal is 28;
   attribute PIN_NO of CN   : signal is 29;
   attribute PIN_NO of F3   : signal is 31;
   attribute PIN_NO of G    : signal is 32;
   attribute PIN_NO of CO   : signal is 33;
   attribute PIN_NO of OVR  : signal is 34;
   attribute PIN_NO of P    : signal is 35;
   attribute PIN_NO of Y0   : signal is 36;
   attribute PIN_NO of Y1   : signal is 37;
   attribute PIN_NO of Y2   : signal is 38;
   attribute PIN_NO of Y3   : signal is 39;
   attribute PIN_NO of OE   : signal is 40;

end Am29C01;

-- ======================================================================

architecture STRUCTURAL of Am29C01 is

-- instantiate components of the all sub-blocks

   component INST_ALU  -- 4-bit ALU
     port (
       RBUS, 
       SBUS : in Fourbit; 
       FBUS : out Fourbit; 
       FUNT : in Threebit;
       CIN  : in Std_Ulogic; 
       G, 
       P, 
       CO, 
       F3, 
       OVR, 
       F : out Std_Ulogic
     );
   end component;
     
   component INST_DECODE -- Instruction decoder
     port (
       SRC, 
       DEST, 
       FUNT        : in Threebit; 
       RMUX_SEL, 
       SMUX_SEL    : out Twobit; 
       YMUX_SEL, 
       QMUX_SEL, 
       Q_LOAD, 
       QSHIFT_DIR, 
       QSHIFT_SEL,
       RAM_EN, 
       RAMSHIFT_DIR, 
       RAMSHIFT_SEL  : out Std_Ulogic; 
       ALU_FUNT : out Threebit
     );
   end component;
  
   component INST_LATCH -- 4-bit latch for RAM outputs
     port (
       DATA_IN : in Fourbit; 
       DATA_OUT : out Fourbit; 
       CP : in Std_Ulogic
     );
   end component;
  
   component INST_QREG -- 4-bit register for q-shift outputs
     port (
       DATA_IN : in Fourbit; 
       DATA_OUT : out Fourbit; 
       CP, 
       QEN : in Std_Ulogic
     );
   end component;
  
   component INST_SHIFTER -- 4-bit shifter
     port (
       DATA : in Fourbit; 
       Y : out Fourbit; 
       SHIFTSEL, 
       DIRECTION : in Std_Ulogic;
       SINLSB, 
       SINMSB : in Std_Ulogic; 
       SOUTLSB, 
       SOUTMSB : out Std_Ulogic 
     );
   end component;
  
   component INST_RAM  -- 16x4 RAM
     port (
       A, 
       B : in Fourbit; 
       AOUT, 
       BOUT : out Fourbit; 
       DATA_IN : in Fourbit;
       RAM_EN, 
       CP : in Std_Ulogic
     );
   end component;
  
   component INST_MUX4TO1 -- mux used for input to A port of RAM
     port (
       IN1, 
       IN2, 
       IN3 : in Fourbit;  
       SEL : in Twobit; 
       O : out Fourbit 
     );
   end component;
  
   component INST_MUX3TO1 -- mux used for input to B port of RAM
     port (
       IN1, 
       IN2 : in Fourbit; 
       SEL : in Twobit; 
       O : out Fourbit
     );
     end component;
  
   component INST_MUX2TO1 -- mux used for input to tri-state buffer
     port (
       IN1, 
       IN2 : in Fourbit; 
       SEL : in Std_Ulogic; 
       O : out Fourbit
     );
   end component;
  
   component INST_TS_BUFFER -- tri-state buffer
     port (
       DATA : in Fourbit; 
       ENABLE : in Std_Ulogic; 
       O : out Fourbit
     );
   end component;        
        
   -- signal declarations for internal data paths 
   
   signal RMUX_IN1          : Fourbit := "ZZZZ";
   signal SMUX_IN1          : Fourbit := "ZZZZ";
   signal SMUX_IN2          : Fourbit := "ZZZZ";
   signal YMUX_IN1          : Fourbit := "ZZZZ";
   signal YMUX_IN2          : Fourbit := "ZZZZ";
   signal RMUX_OUT          : Fourbit := "ZZZZ";
   signal SMUX_OUT          : Fourbit := "ZZZZ";
   signal QMUX_OUT          : Fourbit := "ZZZZ";
   signal RLATCH_IN         : Fourbit := "ZZZZ";
   signal SLATCH_IN         : Fourbit := "ZZZZ";
   signal QREG_IN           : Fourbit := "ZZZZ";
   signal RAM_IN            : Fourbit := "ZZZZ";
   signal TS_IN             : Fourbit := "ZZZZ";
   
   -- signal declarations for internal control lines
   
   signal RMUX_SEL          : Twobit := "ZZ";
   signal SMUX_SEL          : Twobit := "ZZ";
   signal QMUX_SEL          : Std_Ulogic := 'Z';
   signal YMUX_SEL          : Std_Ulogic := 'Z';
   signal Q_LOAD            : Std_Ulogic := 'Z';
   signal QSHIFT_DIR        : Std_Ulogic := 'Z';
   signal QSHIFT_SEL        : Std_Ulogic := 'Z';
   signal RAM_EN            : Std_Ulogic := 'Z';
   signal RAMSHIFT_DIR      : Std_Ulogic := 'Z';
   signal RAMSHIFT_SEL      : Std_Ulogic := 'Z';
   signal ALU_FUNT          : Threebit   := "ZZZ";
   
   -- signal declarations for component port mapping to output pins
   
   signal Q3SIN             : Std_Logic := 'Z';
   signal RAM3SIN           : Std_Logic := 'Z';
   signal Q0SIN             : Std_Logic := 'Z';
   signal RAM0SIN           : Std_Logic := 'Z';
   signal Q3SOUT            : Std_Ulogic := 'Z';
   signal RAM3SOUT          : Std_Ulogic := 'Z';
   signal Q0SOUT            : Std_Ulogic := 'Z';
   signal RAM0SOUT          : Std_Ulogic := 'Z';
   signal YOUT              : Fourbit := "UUUU";
   signal GS                : Std_Ulogic := 'U';
   signal PS                : Std_Ulogic := 'U';
   signal OVRS              : Std_Ulogic := 'U';
   signal FS                : Std_Ulogic := 'U';
   signal F3S               : Std_Ulogic := 'U';
   signal COS               : Std_Ulogic := 'U';
   
   signal Aaddrss           : Fourbit := "ZZZZ";
   signal Baddrss           : Fourbit := "ZZZZ";
   signal Datas             : Fourbit := "ZZZZ";
   signal I876s             : Threebit  := "ZZZ";
   signal I543s             : Threebit  := "ZZZ";
   signal I210s             : Threebit  := "ZZZ";
   signal Cns               : Std_Ulogic := 'Z';
   signal OEs               : Std_Ulogic := 'Z';
   signal CPs               : Std_Ulogic := 'Z';
           
   begin
   
     assert ((OE = '0') OR (OE = '1') OR (OE = 'L') OR (OE = 'H'))
     report "UNKNOWN on control line OE" severity WARNING;
   
     assert ((I8 = '0') OR (I8 = '1') OR (I8 = 'L') OR (I8 = 'H'))
     report "UNKNOWN on control line I8" severity WARNING;
   
     assert ((I7 = '0') OR (I7 = '1') OR (I7 = 'L') OR (I7 = 'H'))
     report "UNKNOWN on control line I7" severity WARNING;
   
     assert ((I6 = '0') OR (I6 = '1') OR (I6 = 'L') OR (I6 = 'H'))
     report "UNKNOWN on control line I6" severity WARNING;
   
     assert ((I5 = '0') OR (I5 = '1') OR (I5 = 'L') OR (I5 = 'H'))
     report "UNKNOWN on control line I5" severity WARNING;
   
     assert ((I4 = '0') OR (I4 = '1') OR (I4 = 'L') OR (I4 = 'H'))
     report "UNKNOWN on control line I4" severity WARNING;
   
     assert ((I3 = '0') OR (I3 = '1') OR (I3 = 'L') OR (I3 = 'H'))
     report "UNKNOWN on control line I3" severity WARNING;
   
     assert ((I2 = '0') OR (I2 = '1') OR (I2 = 'L') OR (I2 = 'H'))
     report "UNKNOWN on control line I2" severity WARNING;
   
     assert ((I1 = '0') OR (I1 = '1') OR (I1 = 'L') OR (I1 = 'H'))
     report "UNKNOWN on control line I1" severity WARNING;
   
     assert ((I0 = '0') OR (I0 = '1') OR (I0 = 'L') OR (I0 = 'H'))
     report "UNKNOWN on control line I0" severity WARNING;
   
     assert ((CP = '0') OR (CP = '1') OR (CP = 'L') OR (CP = 'H'))
     report "UNKNOWN on control line CP" severity WARNING;
   
   -- import signals on input pins 

     OES        <= OE;
     RAM0SIN    <= RAM0;
     RAM3SIN    <= RAM3;
     Q3SIN      <= Q3;
     Q0SIN      <= Q0;
        
   -- port maps for sub modules  

     Aaddrss(3) <= A3;
     Aaddrss(2) <= A2;
     Aaddrss(1) <= A1;
     Aaddrss(0) <= A0;
     Baddrss(3) <= B3;
     Baddrss(2) <= B2;
     Baddrss(1) <= B1;
     Baddrss(0) <= B0;
     Datas(3)   <= D3;
     Datas(2)   <= D2;
     Datas(1)   <= D1;
     Datas(0)   <= D0;
     Cns        <= Cn;
     I210s(2)   <= I2;
     I210s(1)   <= I1;
     I210s(0)   <= I0;
     I543s(2)   <= I5;
     I543s(1)   <= I4;
     I543s(0)   <= I3;
     I876s(2)   <= I8;
     I876s(1)   <= I7;
     I876s(0)   <= I6;
     CPs        <= CP;

----------------------------------------------------------------------

     ALU1 : INST_ALU 
       port map (
         RBUS => RMUX_OUT, 
         SBUS => SMUX_OUT,
         FBUS => YMUX_IN1,
         FUNT => ALU_FUNT,
         CIN  => CNS,
         G    => GS,
         P    => PS,
         CO   => COS,
         F3   => F3S,
         OVR  => OVRS,
         F    => FS
       );

    DECODER1   : INST_DECODE  
       port map (
         SRC          => I210S,
         DEST         => I876S,
         FUNT         => I543S,
         RMUX_SEL     => RMUX_SEL,
         SMUX_SEL     => SMUX_SEL,
         YMUX_SEL     => YMUX_SEL,
         QMUX_SEL     => QMUX_SEL,
         Q_LOAD       => Q_LOAD,
         QSHIFT_DIR   => QSHIFT_DIR,
         QSHIFT_SEL   => QSHIFT_SEL,
         RAM_EN       => RAM_EN,
         RAMSHIFT_DIR => RAMSHIFT_DIR,
         RAMSHIFT_SEL => RAMSHIFT_SEL,
         ALU_FUNT     => ALU_FUNT
       );

     LATCHR     : INST_LATCH   
       port map (
         DATA_IN  => RLATCH_IN,
         DATA_OUT => RMUX_IN1,
         CP       => CPS
       );
                                          
     LATCHS : INST_LATCH  
       port map (
         DATA_IN  => SLATCH_IN,
         DATA_OUT => SMUX_IN2,
         CP       => CPS
       );
                                             
     QREG1      : INST_QREG  
       port map (
         DATA_IN  => QREG_IN,
         DATA_OUT => SMUX_IN1,
         CP       => CPS,
         QEN      => Q_LOAD
     );

     RAM1       : INST_RAM      
       port map (
         A       => AADDRSS,
         B       => BADDRSS,
         AOUT    => RLATCH_IN,
         BOUT    => SLATCH_IN,
         DATA_IN => RAM_IN,
         RAM_EN  => RAM_EN,
         CP      => CPS
      );

    RMUX1      : INST_MUX3TO1  
       port map (
         IN1 => RMUX_IN1,
         IN2 => DATAS,
         O   => RMUX_OUT,
         SEL => RMUX_SEL
       );

   RAMSHIFT1  : INST_SHIFTER
     port map (
        DATA      => YMUX_IN1, 
        Y         => RAM_IN, 
        SHIFTSEL  => RAMSHIFT_SEL, 
        DIRECTION => RAMSHIFT_DIR,
        SINLSB    => RAM0SIN, 
        SINMSB    => RAM3SIN, 
        SOUTLSB   => RAM0SOUT, 
        SOUTMSB   => RAM3SOUT
     );
                                          
   QSHIFT1 : INST_SHIFTER
     port map (
       DATA      => QMUX_OUT, 
       Y         => QREG_IN, 
       SHIFTSEL  => QSHIFT_SEL, 
       DIRECTION => QSHIFT_DIR,
       SINLSB    => Q0SIN, 
       SINMSB    => Q3SIN, 
       SOUTLSB   => Q0SOUT, 
       SOUTMSB   => Q3SOUT
     );
                                             
   SMUX1  : INST_MUX4TO1 
     port map (
       IN1 => SMUX_IN1, 
       IN2 => SMUX_IN2,       
       IN3 => RMUX_IN1, 
       O   => SMUX_OUT, 
       SEL => SMUX_SEL
     );
                                             
   QMUX1 : INST_MUX2TO1  
     port map (
       IN1 => YMUX_IN1, 
       IN2 => SMUX_IN1, 
       O   => QMUX_OUT,
       SEL => YMUX_SEL
     );
                                             
   YMUX1      : INST_MUX2TO1  
     port map (
       IN1 => YMUX_IN1, 
       IN2 => RMUX_IN1, 
       O   => TS_IN,
       SEL => YMUX_SEL
     );
                                             
   TS_BUFFER1 : INST_TS_BUFFER
     port map (
       DATA   => TS_IN, 
       ENABLE => OES, 
       O      => YOUT
     );  

    -- assign output pins

    Y0   <= YOUT(0);
    Y1   <= YOUT(1);
    Y2   <= YOUT(2);
    Y3   <= YOUT(3);
    G    <= GS;
    P    <= PS;
    OVR  <= OVRS;
    F    <= FS;
    F3   <= F3S;
    CO   <= COS;
    Q3   <= Q3SOUT;
    Q0   <= Q0SOUT;
    RAM3 <= RAM3SOUT;
    RAM0 <= RAM0SOUT;
                  
 end;    
 
        
