use work.waves_standard.all;
package waves_logic is
  type logic_value is ( logic_i0, logic_i1, logic_o0, logic_o1);
  function value_dictionary(value : logic_value) return event_value;
end waves_logic;

package body waves_logic is
  function value_dictionary(value : logic_value) return event_value is
  begin
    case value is
      when logic_i0 => return (state = low and strength = drive and
                               direction = stimulus and relevance = required);
      when logic_i1 => return (state = high and strength = drive and
                               direction = stimulus and relevance = required);
      when logic_o0 => return (state = low and strength = drive and
                               direction = response and relevance = required);
      when logic_o1 => return (state = high and strength = drive and
                               direction = response and relevance = required);
    end case;
  end value_dictionary;
end waves_logic;

