entity slave_clock is
  generic
    ( constant pulse_width  : time := 40 ns;
      constant pulse_delay  : time := 10 ns);

  port
    ( external_trigger         : in bit;
      Clock_out                : out bit := '0');

--  This is a leading edge triggered clock!

end slave_clock;

architecture slave_clock of slave_clock is

  begin

  clock:block ((external_trigger = '0')and not(external_trigger'stable))

    begin
      process (guard)
        begin
        if GUARD then
          Clock_out <=       '1' after pulse_delay,
                             '0' after pulse_width+pulse_delay;
          end if;
        end process;
    end block;
  end slave_clock;

