/*******************************************************************************
* mut     : constantes, externs, and data-structures                           *
*                                                                              *
* version : 3.14                                                               *
* date    : 31/08/93                                                           *
*******************************************************************************/
#ifndef MUTL
#define MUTL

#include <stdio.h>
#include <signal.h>

/* namealloc hash table size */
#define HASHVAL     1021

/* hash tables management defines */
#define EMPTYHT     -1
#define DELETEHT    -2


/* read-write text-files opening codes */
#define READ_TEXT   "r" /* read  access */
#define WRITE_TEXT  "w" /* write access */

/* chain buffer size */
#define BUFSIZE     1024
#define SIGSIZE     1024

/* USER field codes  */
#define LOFIGCHAIN  4592
#define PLACEABOX   5749
#define VTIPARSER   9716
#define CHECKFEED   6996
#define UNFLATLOFIG 1992

/* concatenate names while flattening or copying up */
#define YES         'Y'
#define NO          'N'

/*******************************************************************************
* macro definitions                                                            *
*******************************************************************************/
#define EXIT(x)      (void)kill(getpid(), SIGTERM)
#define isvdd(name)	instr(name, VDD, SEPAR)
#define isvss(name)	instr(name, VSS, SEPAR)

/*******************************************************************************
* service structures types                                                     *
*******************************************************************************/

typedef struct point                           /* point list                  */
{
struct point *NEXT;                            /* next point                  */
long         INDEX;                            /* index (unique)              */
long         X,Y;                              /* coordinates                 */
}
point_list;

typedef struct chain                           /* pointer list, lisp lists    */
{
struct chain *NEXT;                            /* next pointer                */
void         *DATA;                            /* generic pointer             */
}
chain_list;

typedef struct ptype                           /* typed pointer list          */
{
struct ptype *NEXT;                            /* next pointer                */
void         *DATA;                            /* generic pointer             */
long         TYPE;                             /* type                        */
}
ptype_list;

typedef struct num                             /* integer list                */
{
struct num *NEXT;                              /* next integer                */
long       DATA;                               /* integer value               */
}
num_list;


/******************************************************************************
* hash table structures types                                                 *
******************************************************************************/
typedef struct htitem {                        /* hash table element          */
	void *key;                                  /* pointer for access          */
	int value;                                  /* associated value            */
} htitem;

typedef struct htable {                        /* hash table itself           */
	int length;                                 /* table length                */
	htitem *pElem;                              /* pointer to table start      */
	int count;                                  /* number of inserted elements */
} ht;

/*******************************************************************************
* mbk externals for the global variables defined in mbk_util.c                 *
*******************************************************************************/
extern chain_list *HEAD_CHAIN;                 /* chain list buffer head      */
extern ptype_list *HEAD_PTYPE;                 /* ptype list buffer head      */
extern num_list   *HEAD_NUM;                   /* num list buffer head        */
extern char       TRACE_MODE;                  /* trace if Y                  */
extern char       DEBUG_MODE;                  /* debug if Y                  */
extern char       FAST_MODE;                   /* no consistency control if Y */
extern char       *WORK_LIB;                   /* working directory           */
extern char       **CATA_LIB;                  /* read only directory         */
extern char       *CATAL;                      /* catalog file name           */
extern char       SEPAR;                       /* char used for concatenation */
extern char       IN_LO[];                     /* logical input format        */
extern char       IN_PH[];                     /* physical input format       */
extern char       OUT_LO[];                    /* logical output format       */
extern char       OUT_PH[];                    /* physical output format      */
extern long       SCALE_X;                     /* distance scale parameter    */
extern char       PARSER_INFO[];               /* version number, and so on   */
extern char       *VDD;                        /* user name for power high    */
extern char       *VSS;                        /* user name for power ground  */

/*******************************************************************************
* externals for mbk_util.c functions                                           *
*******************************************************************************/
extern void mbkenv();
extern char *nameindex();
extern num_list *addnum();
extern void freenum();
extern chain_list *addchain();
extern chain_list *delchain();
extern void freechain();
extern ptype_list *addptype();
extern ptype_list *delptype();
extern void freeptype();
extern ptype_list *getptype();
extern chain_list *append();
extern char *namealloc();
extern char *mbkstrdup();
extern void downstr();
extern void upstr();
extern char *instr();
extern char *vectorize();
extern char *vectorradical();
extern int vectorindex();
extern char *concatname();
extern chain_list *reverse();
extern int naturalstrcmp();
extern ht *addht() ;
extern int gethtitem() ;
extern int addhtitem() ;
extern int sethtitem() ;
extern int delhtitem();
extern void viewht();
extern void delht();
extern int incatalog();
extern int incataloggds();
extern int incatalogfeed();
extern int incatalogdelete();
extern void alliancebanner();

/*******************************************************************************
* externals for mbk_sys.c functions                                            *
*******************************************************************************/
extern void *mbkalloc();
extern void *mbkrealloc();
extern void mbkfree();
extern FILE *mbkfopen();
extern int mbkunlink();
extern char *filepath();
extern void mbkps();

/*******************************************************************************
* externals for mbk_fake.c  or parsers drivers functions                       *
*******************************************************************************/
extern void vtiloadphfig();
extern void vtiloadlofig();
extern void alcloadphfig();
extern void alcloadlofig();
extern void spiceloadlofig();
extern void vhdlloadlofig();
extern void hiloloadlofig();
extern void edifloadlofig();
extern void vtisavephfig();
extern void vtisavelofig();
extern void alcsavephfig();
extern void alcsavelofig();
extern void spicesavelofig();
extern void vhdlsavelofig();
extern void hilosavelofig();
extern void edifsavelofig();
extern void mgnloadphfig();
extern void mgnsavephfig();

#endif /* !MUTL */
