/*===========================+==========================================*/
/*									*/
/* file		: dxlasm_defs.h						*/
/* version	: v0.1							*/
/* date		: Mar 31 1993						*/
/* author	: Pirouz BAZARGAN SABET					*/
/* version	: v1.1							*/
/* date		: Sept 30 1995						*/
/* author	: Martin Gumm    					*/
/* description	: DLX assembler - defines (operation codes)		*/
/* comment      :  modified version of the DLX assembler                */
/*									*/
/*======================================================================*/

#define DLX_PLSDFN 0
#define DLX_MNSDFN 1
#define DLX_SHLDFN 2
#define DLX_SHRDFN 3
#define DLX_ORDFN  4
#define DLX_ANDDFN 5
#define DLX_XORDFN 6

#define DLX_HSZDFN 97
#define DLX_ALODFN 20

#define DLX_INT_SIMPLE  0     /* only signed integer, no mult./div. */
#define DLX_INT_S_AND_U 1     /* signed and unsigned integer, no mult./div.*/
#define DLX_INT_COMPLEX 2     /* signed and unsigned integer, mult./div. */
#define DLX_FLOAT       3     /* allinstructions including floating point */


/*----------------------------------------------------------------------- */
/* A dlx instruction is 32 bits wide. There are three instruction formats:*/
/*                                                                        */
/* I-type:                                                                */
/*  0         5 6      10 11     15 16                            31      */
/* +----------------------------------------------------------------+     */
/* |  opcode   |   rs1   |   rd    |           immed16              |     */
/* +----------------------------------------------------------------+     */
/*                                                                        */
/* Encodes: - loads and stores of bytes, words, half-words                */
/*          - all immediates (rd <- rs1 op immediate)                     */
/*          - conditional branch instructions (rd unused)                 */
/*          - jump register, jump and link register                       */
/*            (rd = 0; rs = dezstination; immediate = 0)                  */
/*                                                                        */
/* R-type:                                                                */
/*  0         5 6      10 11     15 16     20 21     25 26        31      */
/* +----------------------------------------------------------------+     */
/* |  opcode   |   rs1   |   rs2   |   rd    |         func         |     */
/* +----------------------------------------------------------------+     */
/*                                           | fp_func |  rr_func   |     */
/*                                           +----------------------+     */
/*                                                                        */
/* Encodes: - resister-register ALU operations (rd <- rs1 func rs2)       */
/*            function encodes the datapath operation (add, sub, ...)     */
/*            read/write special registers and moves                      */
/*                                                                        */
/* J-type:                                                                */
/*  0         5 6                                                 31      */
/* +----------------------------------------------------------------+     */
/* |  opcode   |                     immed26                        |     */
/* +----------------------------------------------------------------+     */
/*                                                                        */
/* Encodes: - jump and jump-and-link                                      */
/*          - trap and rfe                                                */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*      _RR_FUNC 0x00000000 */
#define _LHU_I   0x04000000
#define _LBU_I   0x08000000
/* undef         0x0C000000 */
#define _LW_I    0x10000000
#define _LH_I    0x14000000
#define _LB_I    0x18000000
/* undef         0x1C000000 */
#define _SW_I    0x20000000
#define _SH_I    0x24000000
#define _SB_I    0x28000000
/* undef         0x2C000000 */

#define _J       0x30000000
#define _JAL     0x34000000
#define _JR      0x38000000
#define _JALR    0x3C000000
#define _BEQZ    0x40000000
#define _BNEZ    0x44000000
#define _RFE     0x48000000
#define _TRAP    0x4C000000

#define _ADD_I	 0x50000000
#define _ADDU_I	 0x54000000
#define _SUB_I	 0x58000000
#define _SUBU_I	 0x5c000000
#define _AND_I	 0x60000000
#define _OR_I	 0x64000000
#define _XOR_I	 0x68000000
#define _LHI	 0x6C000000
#define _SLL_I	 0x70000000
/* undef         0x74000000 */
#define _SRL_I	 0x78000000
#define _SRA_I	 0x7C000000

#define _SEQ_I	 0x80000000
#define _SEQU_I	 0x84000000
#define _SNE_I	 0x88000000
#define _SNEU_I	 0x8C000000
#define _SLT_I	 0x90000000
#define _SLTU_I	 0x94000000
#define _SLE_I	 0x98000000
#define _SLEU_I	 0x9C000000
#define _SGT_I	 0xA0000000
#define _SGTU_I	 0xA4000000
#define _SGE_I	 0xA8000000
#define _SGEU_I	 0xAC000000

/* undef         0xB0000000 */
/* undef         0xB4000000 */
/* undef         0xB8000000 */
/* undef         0xBC000000 */
#define _LF_I	 0xC0000000
#define _LD_I	 0xC4000000
/* undef         0xC8000000 */
/* undef         0xCC000000 */
#define _SF_I	 0xD0000000
#define _SD_I	 0xD4000000
/* undef         0xD8000000 */
/* undef         0xDC000000 */
#define _BFPT	 0xE0000000
#define _BFPF	 0xE4000000
/* undef         0xE8000000 */
/* undef         0xEC000000 */
/*      _FP_FN	 0xF0000000 */
/* undef	 0xF4000000 */
/* undef         0xF8000000 */
/* undef         0xFC000000 */

/* register register ALU functions and registe indexed load/store */

#define _NOP     0x00000000
/* undef	 0x00000001 */
#define _MOVI2S	 0x00000002
#define _MOVS2I	 0x00000003

#define _ADD     0x00000004
#define _ADDU    0x00000005
#define _SUB     0x00000006
#define _SUBU    0x00000007
#define _AND	 0x00000008
#define _OR	 0x00000009
#define _XOR	 0x0000000A
/* undef         0x0000000B */
#define _SLL	 0x0000000C
/* undef         0x0000000D */
#define _SRL	 0x0000000E
#define _SRA	 0x0000000F

#define _SEQ	 0x00000010
#define _SEQU	 0x00000011
#define _SNE	 0x00000012
#define _SNEU	 0x00000013
#define _SLT	 0x00000014
#define _SLTU	 0x00000015
#define _SLE	 0x00000016
#define _SLEU	 0x00000017
#define _SGT	 0x00000018
#define _SGTU	 0x00000019
#define _SGE	 0x0000001A
#define _SGEU	 0x0000001B

#define _MOVF	 0x0000001C
#define _MOVD	 0x0000001D
#define _MOVFP2I 0x0000001E
#define _MOVI2FP 0x0000001F

#define _LW      0x00000020
#define _LH      0x00000021
#define _LB      0x00000022
/* undef         0x00000023 */
/* undef         0x00000024 */
#define _LHU     0x00000025
#define _LBU     0x00000026
/* undef         0x00000027 */
#define _SW      0x00000028
#define _SH      0x00000029
#define _SB      0x0000002A
/* undef         0x0000002B */
#define _LF	 0x0000002C
#define _LD	 0x0000002D
/* undef         0x0000002E */
/* undef         0x0000002F */
#define _SF	 0x00000030
#define _SD	 0x00000031
/* undef         0x00000032 */
/*        ...               */
/* undef         0x0000003f */

/* floating point instructions */

#define _ADDF    0xF0000000
#define _SUBF    0xF0000040
#define _MULTF   0xF0000080
#define _DIVF    0xF00000C0
#define _ADDD    0xF0000100
#define _SUBD    0xF0000140
#define _MULTD   0xF0000180
#define _DIVD    0xF00001C0
#define _CVTF2D  0xF0000200
#define _CVTF2I  0xF0000240
#define _CVTD2F  0xF0000280
#define _CVTD2I  0xF00002C0
#define _CVTI2F  0xF0000300
#define _CVTI2D  0xF0000340
/* undef         0xF0000380 */
/* undef         0xF00003C0 */

#define _MULT    0xF0000400
#define _MULTU   0xF0000440
#define _DIV     0xF0000480
#define _DIVU    0xF00004C0
#define _EQF     0xF0000500 
#define _NEF     0xF0000540
#define _LTF     0xF0000580
#define _LEF     0xF00005C0
#define _GTF     0xF0000600
#define _GEF     0xF0000640
#define _EQD     0xF0000680 
#define _NED     0xF00006C0
#define _LTD     0xF0000700
#define _LED     0xF0000740
#define _GTD     0xF0000780
#define _GED     0xF0000800

/* pseudo opcodes */
/* (4th value only to distinguish from other opcodes) */

#define _MOV    0x80010000     /* = OR   Rd, Rs, R0 */ 
#define _CLR    0x80020000     /* = AND  Rd, R0, R0 */ 
#define _NOT    0x80030000     /* = XOR_I Rd, Rs, #X"FFFF" */ 
#define _LIW	0x80040000     /* = LHI  Rd, #high16 ; OR_I Rd, Rd, #low16 */
#define _LIS    0x80050000     /* = ADD_I Rd, R0, #16bit */
#define _LIU    0x80060000     /* = ADDU_I Rd, R0, #16bit */

/* special register addresses */
/* (first value only to distinguish from other opcodes) */

#define _ICR	0x80000001     
#define _IAR    0x80000002     
#define _TBR    0x80000004
#define _FPSR   0x80000008     


