;  ###----------------------------------------------------------------###
;  #									#
;  # file	: loadstore      					#
;  # date	: Feb 22, 1995  					#
;  # descr.	: test load and store instructions			#
;  #									#
;  ###----------------------------------------------------------------###


		org	X"8000_0000"
		start	init

mem_base1	equ 	X"8fff_fff0"
mem_base2	equ	X"9000_0000"
word1		equ	X"0123_4567"
word2		equ	X"ff00_00ff"
half0		equ	X"7fff"
half1		equ	X"fa51"
sext_half0	equ	X"0000_7fff"
sext_half1	equ	X"ffff_fa51"
half2		equ	X"6af1"
half3		equ	X"8001"
sext_half2	equ	X"0000_6af1"
sext_half3	equ	X"ffff_8001"
byte0		equ	X"23"
byte1		equ	X"7f"
byte2		equ	X"ab"
byte3		equ	X"fe"
sext_byte0	equ	X"0000_0023"
sext_byte1	equ	X"0000_007f"
sext_byte2	equ	X"ffff_ffab"
sext_byte3	equ	X"ffff_fffe"
byte4		equ	X"3c"
byte5		equ	X"60"
byte6		equ	X"cc"
byte7		equ	X"99"
sext_byte4	equ	X"0000_003c"
sext_byte5	equ	X"0000_0060"
sext_byte6	equ	X"ffff_ffcc"
sext_byte7	equ	X"ffff_ff99"

init:
		liw 	r29, mem_base1
		liw	r30, mem_base2
	
		liw	r1, word1	; check word access immed. index
		sw.i	16(r29), r1	; addr 9000_0000
		lw.i	r2, 0(r30)      ; "
		seq	r3, r1, r2
		bnez	r3, cont_1

error_1		nop
		j	error_1		; error: endless loop 

cont_1		liw	r1, word2	; check word access reg. index
		lis	r27, 20
		lis 	r28, 4	
		sw	r27(r29), r1	; addr 9000_004
		lw	r2, r28(r30)	; "
		seq	r3, r1, r2
		bnez	r3, cont_2
		
error_2		nop
		j	error_2		; error: endless loop 

cont_2		liu	r1, half0	; check half access immed index
		liu 	r2, half1
		sh.i	24(r29), r1 	; addr 9000_0008     
		sh.i	26(r29), r2	; addr 9000_000A
		lh.i	r3, 8(r30) 	; addr 9000_0008
		lh.i	r4, 10(r30) 	; addr 9000_000A
		liw	r5, sext_half0
		liw	r6, sext_half1
		seq	r7, r5, r3
		beqz	r7, error_3
		seq	r7, r6, r4
		bnez	r7, cont_3				
		
error_3		nop
		j	error_3		; error: endless loop 

cont_3		liu	r1, half2	; check half access reg. index
		liu 	r2, half3
		liu	r24, 28
		liu	r25, 30
		liu	r26, 12
		liu	r27, 14
		sh	r24(r29), r1 	; addr 9000_000C        
		sh	r25(r29), r2	; addr 9000_000E   
		lh	r3, r26(r30)	; addr 9000_000C   
		lh	r4, r27(r30)	; addr 9000_000E   
		liw	r5, sext_half2
		liw	r6, sext_half3
		seq	r7, r5, r3
		beqz	r7, error_4
		seq	r7, r6, r4
		bnez	r7, cont_4				

error_4		nop
		j	error_2		; error: endless loop 

cont_4		liu	r1, byte0	; check byte access
		liu	r2, byte1
		liu	r3, byte2
		liu	r4, byte3
		sb.i	32(r29), r1	; addr 9000_0010
		sb.i	33(r29), r2	; addr 9000_0011
		sb.i	34(r29), r3	; addr 9000_0012
		sb.i	35(r29), r4	; addr 9000_0013
		lb.i	r5, 16(r30)	; addr 9000_0010
		lb.i	r6, 17(r30)	; addr 9000_0011
		lb.i	r7, 18(r30)	; addr 9000_0012
		lb.i	r8, 19(r30)	; addr 9000_0013
		liw	r9, sext_byte0
		liw	r10, sext_byte1
		liw	r11, sext_byte2
		liw	r12, sext_byte3
		seq	r13, r5, r9
		beqz	r13, error_5
		seq	r13, r6, r10
		beqz	r13, error_5
		seq	r13, r7, r11
		beqz	r13, error_5
		seq	r13, r8, r12
		bnez	r13, cont_5

error_5		nop
		j	error_3		; error: endless loop 
			        
cont_5		liu	r1, byte4	; check byte access
		liu	r2, byte5
		liu	r3, byte6
		liu	r4, byte7
		liu	r20, 36
		liu	r21, 37
		liu	r22, 38
		liu	r23, 39
		liu	r24, 20
		liu	r25, 21
		liu	r26, 22
		liu	r27, 23
		sb	r20(r29), r1	; addr 9000_0014
		sb	r21(r29), r2	; addr 9000_0015
		sb	r22(r29), r3	; addr 9000_0016
		sb	r23(r29), r4	; addr 9000_0017
		lb	r5, r24(r30)	; addr 9000_0014
		lb	r6, r25(r30)	; addr 9000_0015
		lb	r7, r26(r30)	; addr 9000_0016
		lb	r8, r27(r30)	; addr 9000_0017
		liw	r9, sext_byte4
		liw	r10, sext_byte5
		liw	r11, sext_byte6
		liw	r12, sext_byte7
		seq	r13, r5, r9
		beqz	r13, error_5
		seq	r13, r6, r10
		beqz	r13, error_5
		seq	r13, r7, r11
		beqz	r13, error_5
		seq	r13, r8, r12
		bnez	r13, cont_6

error_6		nop
		j	error_6		; error: endless loop 
	
cont_6		j	init		;restart

                end
