--------------------------------------------------------------------
-- VLSI Design Course / University of Stuttgart
--------------------------------------------------------------------
-- Designers : 
-- Group No. : 
--------------------------------------------------------------------
-- Design Unit Name : rs_ff_test(bench)
-- Purpose : architecture for the RS flipflop test-bench
-- 
-- File Name : rs_ff_test-bench.vhd
--------------------------------------------------------------------
-- Simulator : SYNOPSYS VHDL System Simulator (VSS) Version 3.2.
--------------------------------------------------------------------
--  Date	   | Changes
--  01 October 95  | original version
--
--------------------------------------------------------------------

ARCHITECTURE bench OF rs_ff_test IS

  COMPONENT rs_ff
    PORT (S, R : in std_logic;
      	  Q, QB :out std_logic);
  END COMPONENT;
  
  SIGNAL set, res, qout, qbout : std_logic;
  
BEGIN
  --
  -- Instantiation of the RS-flipflopin the test-bench architecture.
  --
  ff1 : rs_ff
    PORT MAP (s => set, r => res, q => qout, qb => qbout);

  --
  -- create two input waveforms for the flipflop-inputs
  --
      
  --
  -- 1. version of stimuli generation
  -- (only allowed input signals for the RS Flipflop)
  --
  --set <= '0',
  --       '1' after 2 ns,
  --       '0' after 8 ns;
  --
  --res <= '0',
  --       '1' after 12 ns,
  --       '0' after 16 ns;

  --
  -- 2. version of stimuli generation
  -- (does not generate correct input signals)
  --
  --  set <= '0';
  --  set <= '1' after 2 ns;
  --  set <= '0' after 8 ns;
  --	 
  --  res <= '0';
  --  res <= '1' after 12 ns;
  --  res <= '0' after 16 ns;

  --
  -- 3. version of stimuli generation
  -- (does not generate correct input signals)
  -- stimuli_3 : process
  -- begin  
  --   set <=  '0';
  --   set <=  '1' after 2 ns;
  --   set <=  '0' after 8 ns;
  --   	 
  --   res <=  '0';
  --   res <=  '1' after 12 ns;
  --   res <=  '0' after 16 ns;
  --   wait;
  -- end process stimuli_3;
      
  --
  -- 4. version of stimuli generation
  -- (does not generate correct input signals)
  --
  -- set <= transport '0';
  -- set <= transport '1' after 2 ns;
  -- set <= transport '0' after 8 ns;
  --	 
  -- res <= transport '0';
  -- res <= transport '1' after 12 ns;
  -- res <= transport '0' after 16 ns;
  
  --
  -- 5. version of stimuli generation
  -- (generates correct input signals)
  --
   stimuli_5 : process
   begin  
     set <= transport '0';
     set <= transport '1' after 2 ns;
     set <= transport '0' after 8 ns;
  	 
     res <= transport '0';
     res <= transport '1' after 12 ns;
     res <= transport '0' after 16 ns;
     wait;
   end process stimuli_5;

  --
  -- 6. version of stimuli generation
  -- (not allowed input signals for the RS Flipflop)
  --
  --  set <= '0',
  --         '1' after 2 ns,
  --	     '0' after 8 ns,
  --	     '1' after 20 ns,             -- not allowed state (set = res = 1)
  --	     '0' after 24 ns;
  --	 
  --  res <= '0',
  --         '1' after 12 ns,
  --	     '0' after 16 ns,
  --	     '1' after 20 ns,             -- not allowed state (set = res = 1)
  --	     '0' after 24 ns;
      
END bench;
	     

