--------------------------------------------------------------------
-- VLSI Design Course / University of Stuttgart
--------------------------------------------------------------------
-- Designers : 
-- Group No. : 
--------------------------------------------------------------------
-- Design Unit Name : rs_ff(structural)
-- Purpose :  structural architecture for the RS flipflop
-- 
-- File Name : rs_ff-structural.vhd
--------------------------------------------------------------------
-- Simulator : SYNOPSYS VHDL System Simulator (VSS) Version 3.2.
--------------------------------------------------------------------
--  Date	   | Changes
--  01 October 95  | original version
--
--------------------------------------------------------------------

--------------------------------------------------------------------
--                 ___
--       S --------\  \
--                  |  |o----+--------- QB
--             +---/__/      |
--             |             |
--             +-----------------+
--                           |   |
--             +-------------+   |
--             |   ___           |
--             +---\  \          |
--                  |  |o--------+----- Q
--       R ------- /__/     
--
---------------------------------------------------------------------
		   
library TEACH_LOGIC_LIB;
use TEACH_LOGIC_LIB.logic_components.all;

architecture structural of rs_ff is
  --
  -- internal signal for Q and QB because it is not possible to read
  -- from port signals of the type "OUT"
  --
  signal q_int, qb_int : std_logic;
  
begin
  --
  -- RS-fliflop containing 2 crosscoupled NOR-gates
  --
  snor : nor2
    port map (a => S, b => q_int, y => qb_int);

  rnor : nor2
    port map (a => R, b => qb_int, y => q_int);

  --
  -- connect inetrnal signals to port signals
  --
  Q  <= q_int;
  QB <= qb_int;

end structural;



