--------------------------------------------------------------------
-- VLSI Design Course / University of Stuttgart
--------------------------------------------------------------------
-- Designers : 
-- Group No. : 
--------------------------------------------------------------------
-- Design Unit Name : rs_ff(dataflow)
-- Purpose :  dataflow architecture for the RS flipflop
-- 
-- File Name : rs_ff-dataflow.vhd
--------------------------------------------------------------------
-- Simulator : SYNOPSYS VHDL System Simulator (VSS) Version 3.2.
--------------------------------------------------------------------
--  Date	   | Changes
--  01 October 95  | original version
--
--------------------------------------------------------------------

--------------------------------------------------------------------
--                 ___
--       S --------\  \
--                  |  |o----+--------- QB
--             +---/__/      |
--             |             |
--             +-----------------+
--                           |   |
--             +-------------+   |
--             |   ___           |
--             +---\  \          |
--                  |  |o--------+----- Q
--       R ------- /__/     
--
---------------------------------------------------------------------
		   
architecture dataflow of rs_ff is
  --
  -- internal signal for Q and QB because it is not possible to read
  -- from port signals of the type "OUT"
  --
  signal q_int, qb_int : std_logic;
  
begin
  --
  -- RS-fliflop containing 2 crosscoupled NOR-gates
  --
  QB_int <= not (S or q_int) after tpd_snor;
  Q_int  <= not (R or qb_int) after tpd_rnor;
  --
  -- connect inetrnal signals to port signals
  --
  Q  <= q_int;
  QB <= qb_int;
end dataflow;
