--------------------------------------------------------------------
-- VLSI Design Course / University of Stuttgart
--------------------------------------------------------------------
-- Designers : 
-- Group No. : 
--------------------------------------------------------------------
-- Design Unit Name : rs_ff(behaviour)
-- Purpose : behavioural architecture for the RS flipflop
-- 
-- File Name : rs_ff-behaviour.vhd
--------------------------------------------------------------------
-- Simulator : SYNOPSYS VHDL System Simulator (VSS) Version 3.2.
--------------------------------------------------------------------
--  Date	   | Changes
--  01 October 95  | original version
--
--------------------------------------------------------------------

--------------------------------------------------------------------
--                 ___
--       S --------\  \
--                  |  |o----+--------- QB
--             +---/__/      |
--             |             |
--             +-----------------+
--                           |   |
--             +-------------+   |
--             |   ___           |
--             +---\  \          |
--                  |  |o--------+----- Q
--       R ------- /__/     
--
---------------------------------------------------------------------
		   
architecture behaviour of rs_ff is
  --
  -- internal signal for Q and QB because it is not possible to read
  -- from port signals of the type "OUT"
  --
  signal q_int, qb_int : std_logic;
begin
  flipflop: process
  begin
    --
    -- wait until an event occurres for one of the given signals
    --
    wait on S, R, q_int, qb_int;
    
    if S = '1' or q_int = '1' then
      qb_int <= '0' after tpd_snor;
    elsif S = '0' and q_int = '0' then
      qb_int <= '1' after tpd_snor;
    else
      qb_int <= 'X' after tpd_snor;
    end if;

    if R = '1' or qb_int = '1' then
      q_int <= '0' after tpd_rnor;
    elsif R = '0' and qb_int = '0' then
      q_int <= '1' after tpd_rnor;
    else
      q_int <= 'X' after tpd_rnor;
    end if;
    --
    -- process ends here (and will be activated again)
    --
  end process flipflop;

  --
  -- connect internal signals to output ports
  --
  q <= q_int;
  qb <= qb_int;
    
end behaviour;
