--------------------------------------------------------------------
-- VLSI Design Course / University of Stuttgart
--------------------------------------------------------------------
-- Designers : 
-- Group No. : 
--------------------------------------------------------------------
-- Design Unit Name : clockgen_test_cfg2
-- Purpose : configuration for the clock generator and its test bench
-- 
-- File Name : clockgen_test-config2.vhd
--------------------------------------------------------------------
-- Simulator : SYNOPSYS VHDL System Simulator (VSS) Version 3.2.
--------------------------------------------------------------------
--  Date	   | Changes
--  01 October 95  | original version
--
--------------------------------------------------------------------

CONFIGURATION clockgen_test_cfg2 OF clockgen_test IS
  --
  -- Choose an architecture for the test-bench entity "clockgen_test"
  -- The name of the chosen architecture is "bench"
  --
  FOR bench
    --
    -- Choose an entity for the component declared in the testbench-
    -- architecture (the chosen entity is "clockgen").
    -- Choose an architecture for the instantiated entity (the chosen
    -- architecture is "dataflow").
    FOR cg : clockgen
      USE ENTITY WORK.clockgen(structural)
        -- Assign values for the generic parameters of the entity "clockgen"
        -- (this defines the generated clock signal)
        --
        GENERIC MAP (tpw => 8 ns, tps => 2 ns);

        for structural

	  FOR reset_driver : TEACH_LOGIC_LIB.logic_components.resetgen
            USE ENTITY TEACH_LOGIC_LIB.resetgen(dataflow)
    	      GENERIC MAP (reset_time => (2*(tpw + tps)));
	  end for;

	  FOR mux : TEACH_LOGIC_LIB.logic_components.mux21
            USE ENTITY TEACH_LOGIC_LIB.mux21(dataflow)
    	      GENERIC MAP (tpd_mux => 0 ns);
	  end for;

	  FOR inv1 : TEACH_LOGIC_LIB.logic_components.inv
            USE ENTITY TEACH_LOGIC_LIB.inv(dataflow)
    	      GENERIC MAP (tpd_inv => (tpw + tps));
	  end for;

	  FOR inv2, inv3 : TEACH_LOGIC_LIB.logic_components.inv
            USE ENTITY TEACH_LOGIC_LIB.inv(dataflow)
    	      GENERIC MAP (tpd_inv => 0 ns);
	  end for;

	  FOR all : TEACH_LOGIC_LIB.logic_components.and2
            USE ENTITY TEACH_LOGIC_LIB.and2(dataflow)
    	      GENERIC MAP (tpd_and => 0 ns);
	  end for;

	  FOR buf1 : TEACH_LOGIC_LIB.logic_components.buf
            USE ENTITY TEACH_LOGIC_LIB.delay(dataflow)
    	      GENERIC MAP (delay_time => tpw);
	  end for;

       end for; -- structural
	
	
    END FOR; -- clockgen
    
  END FOR; -- bench
  
END clockgen_test_cfg2;








