--------------------------------------------------------------------
-- VLSI Design Course / University of Stuttgart
--------------------------------------------------------------------
-- Designers : 
-- Group No. : 
--------------------------------------------------------------------
-- Design Unit Name : clockgen
-- Purpose : entity declaration for the clock generator
-- 
-- File Name : clockgen.vhd
--------------------------------------------------------------------
-- Simulator : SYNOPSYS VHDL System Simulator (VSS) Version 3.2.
--------------------------------------------------------------------
--  Date	   | Changes
--  01 October 95  | original version
--
--------------------------------------------------------------------

--------------------------------------------------------------------------
-- clock generator signals:
--
--       :_____:   :     :   :_____               _____             _____
-- phi1  /     \_____________/     \_____________/     \___________/     \
--       :     :    _____    :          _____               _____
-- phi2  __________/     \_____________/     \_____________/     \________
--       :_________________________________________________ 
-- reset /     :   :     :   :                             \______________
--       :     :   :     :   :                             ^
--       | tpw |tps| tpw |tps|                             t=5*(tpw+tps) 
--
--------------------------------------------------------------------------

library IEEE;
  USE IEEE.std_logic_1164.all;

ENTITY clockgen IS

  GENERIC (tpw : TIME;		          -- clock pulse width
      	   tps : TIME);		          -- clock pulse separation
     					  
  PORT (phi1, phi2 : OUT std_logic ;    -- two-phase non-overlapping clocks
      	reset :      OUT std_logic);    -- synchronous reset
	
END clockgen;

























