--------------------------------------------------------------------
-- VLSI Design Course / University of Stuttgart
--------------------------------------------------------------------
-- Designers : 
-- Group No. : 
--------------------------------------------------------------------
-- Design Unit Name : clockgen(structural)
-- Purpose : structural architecture for the clock generator
-- 
-- File Name : clockgen-structural.vhd
--------------------------------------------------------------------
-- Simulator : SYNOPSYS VHDL System Simulator (VSS) Version 3.2.
--------------------------------------------------------------------
--  Date	   | Changes
--  01 October 95  | original version
--
--------------------------------------------------------------------

--------------------------------------------------------------------------
-- How to generate a two-phase, non-overlapping clock signal with
-- VDHL concurrent statements statements
--
-- Internal signal phia toggles every half clock periode.
-- Internal signal phib follows phia after the clock-pulse width.
-- Output signals phi1 and phi2 are results of
-- logic functions of phia and phib.
--                                    ____      ____      ____      __
--                               phia    :|____|    |____|    |____|
--                                       :____      ____      ____  
--                               phib ___|    |____|    |____|    |___
--                                    tpw:
-- 	                              ___       ___       ___      __ 
-- phi1 <= phia and (not phib)   phi1    |_____|   |_____|   |_____|
--                                         ___       ___       ___
-- phi2 <= (not phia) and phib   phi2 ____|   |_____|   |_____|   |___
--
--------------------------------------------------------------------------

library TEACH_LOGIC_LIB;
use TEACH_LOGIC_LIB.logic_components.all;
  
ARCHITECTURE structural OF clockgen IS

  SIGNAL phia : std_logic;                -- internal signal 
  SIGNAL phib : std_logic;                -- internal signal
  signal intrn_res_out, mux_out, 
         inv2_out, inv3_out : std_logic;
   
BEGIN

  reset_driver: resetgen
    port map (reset_out => intrn_res_out);

  mux: mux21
    port map (in0 => phia, in1 => intrn_res_out, sel => intrn_res_out,
              y => mux_out);

  inv1: inv
    port map (a => mux_out, y => phia);

  buf1: buf
    port map (a => phia, y => phib);

  inv2: inv
    port map (a => phia, y => inv2_out);

  inv3: inv
    port map (a => phib, y => inv3_out);
      
  and_gate_1 : and2
    port map (a => phia, b => inv3_out, y => phi1);

  and_gate_2 : and2
    port map (a => inv2_out, b => phib, y => phi2);

  reset <= intrn_res_out;

END structural;

