--------------------------------------------------------------------
-- VLSI Design Course / University of Stuttgart
--------------------------------------------------------------------
-- Designers : 
-- Group No. : 
--------------------------------------------------------------------
-- Design Unit Name : clockgen(dataflow)
-- Purpose : dataflow architecture for the clock generator
-- 
-- File Name : clockgen-dataflow.vhd
--------------------------------------------------------------------
-- Simulator : SYNOPSYS VHDL System Simulator (VSS) Version 3.2.
--------------------------------------------------------------------
--  Date	   | Changes
--  01 October 95  | original version
--
--------------------------------------------------------------------

--------------------------------------------------------------------------
-- How to generate a two-phase, non-overlapping clock signal with
-- VDHL concurrent statements statements
--
-- Internal signal phia toggles every half clock periode.
-- Internal signal phib follows phia after the clock-pulse width.
-- Output signals phi1 and phi2 are results of
-- logic functions of phia and phib.
--                                    ____      ____      ____      __
--                               phia    :|____|    |____|    |____|
--                                       :____      ____      ____  
--                               phib ___|    |____|    |____|    |___
--                                    tpw:
-- 	                              ___       ___       ___      __ 
-- phi1 <= phia and (not phib)   phi1    |_____|   |_____|   |_____|
--                                         ___       ___       ___
-- phi2 <= (not phia) and phib   phi2 ____|   |_____|   |_____|   |___
--
--------------------------------------------------------------------------

ARCHITECTURE dataflow OF clockgen IS

  CONSTANT clock_period : TIME := 2*(tpw+tps);   -- length of one periode
  SIGNAL phia : std_logic := '1';                -- internal signal 
  SIGNAL phib : std_logic := '0';                -- internal signal
   
BEGIN

  reset_driver: 
    reset <= '1',
             '0' AFTER 2*clock_period + tpw+tps;

  internal_signals:
    phia <= NOT phia AFTER (tpw+tps);
    phib <= phia AFTER tpw;

  generated_signals:
    phi1 <= phia AND NOT phib;
    phi2 <= NOT phia AND phib;

END dataflow;



