--------------------------------------------------------------------
-- VLSI Design Course / University of Stuttgart
--------------------------------------------------------------------
-- Designers : 
-- Group No. : 
--------------------------------------------------------------------
-- Design Unit Name : clockgen(behaviour_1)
-- Purpose : behavioural architecture for the clock generator
-- 
-- File Name : clockgen-behaviour_1.vhd
--------------------------------------------------------------------
-- Simulator : SYNOPSYS VHDL System Simulator (VSS) Version 3.2.
--------------------------------------------------------------------
--  Date	   | Changes
--  01 October 95  | original version
--
--------------------------------------------------------------------

ARCHITECTURE behaviour_1 OF clockgen IS

  CONSTANT clock_period : TIME := 2*(tpw+tps);    -- length of one period

BEGIN
  --
  -- Waveform for the reset signal
  --
  reset_driver: 
    reset <= '1',
             '0' AFTER 2*clock_period + tpw+tps;

  clock_driver_1 : PROCESS
  BEGIN
    phi1 <= '1',
            '0' AFTER tpw;
    phi2 <= '1' AFTER tpw+tps,
            '0' AFTER tpw+tps+tpw;
    --
    -- wait for one clock peroid
    --
    WAIT FOR clock_period;
  END PROCESS clock_driver_1;

--  clock_driver_2 : PROCESS
--  BEGIN
--    LOOP
--      phi1 <= '1',
--              '0' AFTER tpw;
--      phi2 <= '1' AFTER tpw+tps,
--              '0' AFTER tpw+tps+tpw;
--      --
--      -- wait for one clock peroid
--      --
--      WAIT FOR clock_period;
--    END LOOP;
--  END PROCESS clock_driver_2;      
	     
END behaviour_1;
