--------------------------------------------------------------------
-- VLSI Design Course / University of Stuttgart
--------------------------------------------------------------------
-- Designers : 
-- Group No. : 
--------------------------------------------------------------------
-- Design Unit Name : clockgen(behaviour)
-- Purpose : behavioural architecture for the clock generator
-- 
-- File Name : clockgen-behaviour.vhd
--------------------------------------------------------------------
-- Simulator : SYNOPSYS VHDL System Simulator (VSS) Version 3.2.
--------------------------------------------------------------------
--  Date	   | Changes
--  01 October 95  | original version
--
--------------------------------------------------------------------

ARCHITECTURE behaviour OF clockgen IS

  CONSTANT clock_period : TIME := 2*(tpw+tps);    -- length of one period

BEGIN

  clock_driver : PROCESS
  BEGIN
    --
    -- Waveform for the reset signal
    --
    reset <= '1',
             '0' AFTER 2*clock_period + tpw+tps;
    --
    -- Endless loop for clock signals
    --
    LOOP
      phi1 <= '1',
              '0' AFTER tpw;
      phi2 <= '0',
              '1' AFTER tpw+tps,
              '0' AFTER tpw+tps+tpw;
      --
      -- wait for one clock peroid
      --
      WAIT FOR clock_period;
    END LOOP;
  END PROCESS clock_driver;      
	     
END behaviour;




