--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  Partly derived from 
--   - DLX model suite
--     Copyright (C) 1993, Peter J. Ashenden
--     University of Adelaide, Australia / Dept. Computer Science
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Architecture for test bench for the new library functions
--  Test for arithmetical functions
--
--  (file stdl1164_test-bench_2.vhd)
--------------------------------------------------------------------------

architecture bench_2 of stdl1164_test is
  
begin

  process
    constant skip: boolean := true;
    variable L : line;
    variable sv1: std_logic_vector(0 to 7);
    variable sv2: std_logic_vector(1 to 8);
    variable sv3: std_logic_vector(7 downto 0);
    variable sv4: std_logic_vector(8 downto 1);
    variable svhb: std_logic_vector(0 to 3);
    variable svb: std_logic_vector(0 to 7);
    variable svhw: std_logic_vector(0 to 15);
    variable svw: std_logic_vector(0 to 31);
    variable svo: std_logic;
  begin

    ----------------------------------------------------------------
    -- test arithmetic functions
    ----------------------------------------------------------------
    ----------------------------------------------------------------
    -- sv_add: Signed addition with overflow detection
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_add with overflow:"));
    writeline(output, L);

    write(L, string'("  2+2 = "));
    sv_add(To_StdLogicVector(X"02"), To_StdLogicVector(X"02"), sv2, svo);
    write(L, sv2, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv2 = To_StdLogicVector(X"04") and svo = '0';

    write(L, string'("  2+(-3) = "));
    sv_add(To_StdLogicVector(X"02"), To_StdLogicVector(X"FD"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"FF") and svo = '0';

    write(L, string'("  64+64 = "));
    sv_add(To_StdLogicVector(X"40"), To_StdLogicVector(X"40"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80") and svo = '1';

    write(L, string'("  -64+(-64) = "));
    sv_add(To_StdLogicVector(X"C0"), To_StdLogicVector(X"C0"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80") and svo = '0';

    write(L, string'("  ""01XUWZ-0"" + ""11-U-110"" = "));
    sv_add("01X0W01Z", "11-U-110", sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);

    ----------------------------------------------------------------
    -- sv_add: Signed addition without overflow detection
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_add without overflow:"));
    writeline(output, L);

    write(L, string'("  2+2 = "));
    sv_add(To_StdLogicVector(X"02"), To_StdLogicVector(X"02"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"04");

    write(L, string'("  2+(-3) = "));
    sv_add(To_StdLogicVector(X"02"), To_StdLogicVector(X"FD"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"FF");

    write(L, string'("  64+64 = "));
    sv_add(To_StdLogicVector(X"40"), To_StdLogicVector(X"40"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80");

    write(L, string'("  -64+(-64) = "));
    sv_add(To_StdLogicVector(X"C0"), To_StdLogicVector(X"C0"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80");

    write(L, string'("  ""01X0W01Z""+""11-U-110"" = "));
    sv_add("01X0W01Z", "11-U-110", sv1);
    write(L, sv1, B, up);
    writeline(output, L);

    ----------------------------------------------------------------
    -- sv_addu:  Unsigned addition with overflow detection
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_addu with overflow:"));
    writeline(output, L);

    write(L, string'("  2+2 = "));
    sv_addu(To_StdLogicVector(X"02"), To_StdLogicVector(X"02"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"04") and svo = '0';

    write(L, string'("  64+64 = "));
    sv_addu(To_StdLogicVector(X"40"), To_StdLogicVector(X"40"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80") and svo = '0';

    write(L, string'("  128+128 = "));
    sv_addu(To_StdLogicVector(X"80"), To_StdLogicVector(X"80"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"00") and svo = '1';

    write(L, string'("  ""01X0W01Z""+""11-U-110"" = "));
    sv_addu("01X0W01Z", "11-U-110", sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);

    ----------------------------------------------------------------
    -- sv_addu: Unsigned addition without overflow detection
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_addu without overflow:"));
    writeline(output, L);

    write(L, string'("  2+2 = "));
    sv_addu(To_StdLogicVector(X"02"), To_StdLogicVector(X"02"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"04");

    write(L, string'("  64+64 = "));
    sv_addu(To_StdLogicVector(X"40"), To_StdLogicVector(X"40"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80");

    write(L, string'("  128+128 = "));
    sv_addu(To_StdLogicVector(X"80"), To_StdLogicVector(X"80"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"00");

    write(L, string'("  ""01To_StdLogicVector(X0W01Z""+""11-U-110"" = "));
    sv_addu("01X0W01Z", "11-U-110", sv1);
    write(L, sv1, B, up);
    writeline(output, L);

    ----------------------------------------------------------------
    -- sv_sub: Signed subtraction with overflow detection
    ----------------------------------------------------------------

    WAIT for 1 fs;
      
    writeline(output, L);
    write(L, string'("Testing sv_sub with overflow:"));
    writeline(output, L);

    write(L, string'("  2-2 = "));
    sv_sub(To_StdLogicVector(X"02"), To_StdLogicVector(X"02"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"00") and svo = '0';

    write(L, string'("  2-(-3) = "));
    sv_sub(To_StdLogicVector(X"02"), To_StdLogicVector(X"FD"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"05") and svo = '0';

    write(L, string'("  64-(-64) = "));
    sv_sub(To_StdLogicVector(X"40"), To_StdLogicVector(X"C0"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80") and svo = '1';

    write(L, string'("  -64-64 = "));
    sv_sub(To_StdLogicVector(X"C0"), To_StdLogicVector(X"40"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80") and svo = '0';

    write(L, string'("  ""01X0W01Z"" + ""11-U-110"" = "));
    sv_sub("01X0W01Z", "11-U-110", sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);

    ----------------------------------------------------------------
    -- sv_sub: Signed subtraction without overflow detection
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_sub without overflow:"));
    writeline(output, L);

    write(L, string'("  2-2 = "));
    sv_sub(To_StdLogicVector(X"02"), To_StdLogicVector(X"02"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"00");

    write(L, string'("  2-(-3) = "));
    sv_sub(To_StdLogicVector(X"02"), To_StdLogicVector(X"FD"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"05");

    write(L, string'("  64-(-64) = "));
    sv_sub(To_StdLogicVector(X"40"), To_StdLogicVector(X"C0"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80");

    write(L, string'("  -64-64 = "));
    sv_sub(To_StdLogicVector(X"C0"), To_StdLogicVector(X"40"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80");

    write(L, string'("  ""01X0W01Z""+""11-U-110"" = "));
    sv_sub("01X0W01Z", "11-U-110", sv1);
    write(L, sv1, B, up);
    writeline(output, L);

    ----------------------------------------------------------------
    -- sv_subu: Unsigned subtraction with overflow detection
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_subu with overflow:"));
    writeline(output, L);

    write(L, string'("  3-2 = "));
    sv_subu(To_StdLogicVector(X"03"), To_StdLogicVector(X"02"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"01") and svo = '0';

    write(L, string'("  64-64 = "));
    sv_subu(To_StdLogicVector(X"40"), To_StdLogicVector(X"40"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"00") and svo = '0';

    write(L, string'("  64-128 = "));
    sv_subu(To_StdLogicVector(X"40"), To_StdLogicVector(X"80"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"C0") and svo = '1';

    write(L, string'("  ""01X0W01Z"" + ""11-U-110"" = "));
    sv_subu("01X0W01Z", "11-U-110", sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);

    ----------------------------------------------------------------
    -- sv_subu: Unsigned subtraction without overflow detection
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_subu without overflow:"));
    writeline(output, L);

    write(L, string'("  3-2 = "));
    sv_subu(To_StdLogicVector(X"03"), To_StdLogicVector(X"02"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"01");

    write(L, string'("  64-64 = "));
    sv_subu(To_StdLogicVector(X"40"), To_StdLogicVector(X"40"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"00");

    write(L, string'("  64-128 = "));
    sv_subu(To_StdLogicVector(X"40"), To_StdLogicVector(X"80"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"C0");

    write(L, string'("  ""01X0W01Z""+""11-U-110"" = "));
    sv_subu("01X0W01Z", "11-U-110", sv1);
    write(L, sv1, B, up);
    writeline(output, L);

    ----------------------------------------------------------------
    --sv_neg: Signed negation with overflow detection
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testingsv_neg with overflow:"));
    writeline(output, L);

    write(L, string'("  -(3) = "));
    sv_neg(To_StdLogicVector(X"03"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"FD") and svo = '0';

    write(L, string'("  -(-3) = "));
    sv_neg(To_StdLogicVector(X"FD"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"03") and svo = '0';

    write(L, string'("  -(127) = "));
    sv_neg(To_StdLogicVector(X"7F"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"81") and svo = '0';

    write(L, string'("  -(-128) = "));
    sv_neg(To_StdLogicVector(X"80"), sv1, svo);
    write(L, sv1, B, up);
    write(L, string'(", overflow = "));  write(L, svo);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80") and svo = '1';

    ----------------------------------------------------------------
    -- sv_neg: Signed negation without overflow detection
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_neg without overflow:"));
    writeline(output, L);

    write(L, string'("  -(3) = "));
    sv_neg(To_StdLogicVector(X"03"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"FD");

    write(L, string'("  -(-3) = "));
    sv_neg(To_StdLogicVector(X"FD"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"03");

    write(L, string'("  -(127) = "));
    sv_neg(To_StdLogicVector(X"7F"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"81");

    write(L, string'("  -(-128) = "));
    sv_neg(To_StdLogicVector(X"80"), sv1);
    write(L, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(X"80");

    ----------------------------------------------------------------
    ----------------------------------------------------------------
    --  Logical operators
    ----------------------------------------------------------------
    ----------------------------------------------------------------

    ----------------------------------------------------------------
    -- sv_sll: Shift left logical (fill with '0' bits)
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_sll:"));
    writeline(output, L);

    write(L, string'("  10100101 sll 4 = "));
    sv_sll(To_StdLogicVector(B"10100101"), sv1, 4);
    write(l, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(B"01010000");

    ----------------------------------------------------------------
    -- sv_srl: Shift right logical (fill with '0' bits)
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_srl:"));
    writeline(output, L);

    write(L, string'("  10100101 srl 4 = "));
    sv_srl(To_StdLogicVector(B"10100101"),sv2, 4);
    write(l, sv2, B, up);
    writeline(output, L);
    assert sv2 =To_StdLogicVector( B"00001010");

    ----------------------------------------------------------------
    -- sv_sra: Shift right arithmetic (fill with copy of sign bit)
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_sra:"));
    writeline(output, L);

    write(L, string'("  01011010 sra 4 = "));
    sv_sra(To_StdLogicVector(B"01011010"), sv3, 4);
    write(l, sv3, B, up);
    writeline(output, L);
    assert sv3 = To_StdLogicVector(B"00000101");

    write(L, string'("  10100101 sra 4 = "));
    sv_sra(To_StdLogicVector(B"10100101"), sv3, 4);
    write(l, sv3, B, up);
    writeline(output, L);
    assert sv3 = To_StdLogicVector(B"11111010");

    ----------------------------------------------------------------
    -- sv_rol: Rotate left
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_rol:"));
    writeline(output, L);

    write(L, string'("  10100101 rol 3 = "));
    sv_rol(To_StdLogicVector(B"10100101"), sv4, 3);
    write(l, sv4, B, up);
    writeline(output, L);
    assert sv4 = To_StdLogicVector(B"00101101");

    ----------------------------------------------------------------
    -- sv_rol: Rotate right
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_ror:"));
    writeline(output, L);

    write(L, string'("  10100101 ror 3 = "));
    sv_ror(To_StdLogicVector(B"10100101"), sv1, 3);
    write(l, sv1, B, up);
    writeline(output, L);
    assert sv1 = To_StdLogicVector(B"10110100");

    ----------------------------------------------------------------
    ----------------------------------------------------------------
    --  Arithmetic comparison operators.
    ----------------------------------------------------------------
    ----------------------------------------------------------------

    ----------------------------------------------------------------
    -- sv_lt: Signed less than comparison
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_lt:"));
    writeline(output, L);

    write(L, string'("  2 < 2 = "));
    sv_lt(To_StdLogicVector(X"02"), To_StdLogicVector(X"02"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '0';

    write(L, string'("  2 < 3 = "));
    sv_lt(To_StdLogicVector(X"02"), To_StdLogicVector(X"03"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '1';

    write(L, string'("  -2 < 2 = "));
    sv_lt(To_StdLogicVector(X"FE"), To_StdLogicVector(X"02"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '1';

    write(L, string'("  2 < -3 = "));
    sv_lt(To_StdLogicVector(X"02"), To_StdLogicVector(X"FD"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '0';

    ----------------------------------------------------------------
    -- sv_le: Signed less than or equal comparison
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_le:"));
    writeline(output, L);

    write(L, string'("  2 <= 2 = "));
    sv_le(To_StdLogicVector(X"02"), To_StdLogicVector(X"02"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '1';

    write(L, string'("  2 <= 3 = "));
    sv_le(To_StdLogicVector(X"02"), To_StdLogicVector(X"03"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '1';

    write(L, string'("  -2 <= 2 = "));
    sv_le(To_StdLogicVector(X"FE"), To_StdLogicVector(X"02"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '1';

    write(L, string'("  2 <= -3 = "));
    sv_le(To_StdLogicVector(X"02"), To_StdLogicVector(X"FD"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '0';

    ----------------------------------------------------------------
    -- sv_gt: Signed greater than comparison
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_gt:"));
    writeline(output, L);

    write(L, string'("  2 > 2 = "));
    sv_gt(To_StdLogicVector(X"02"), To_StdLogicVector(X"02"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '0';

    write(L, string'("  3 > 2 = "));
    sv_gt(To_StdLogicVector(X"03"), To_StdLogicVector(X"02"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '1';

    write(L, string'("  2 > -2 = "));
    sv_gt(To_StdLogicVector(X"02"), To_StdLogicVector(X"FE"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '1';

    write(L, string'("  -3 > 2 = "));
    sv_gt(To_StdLogicVector(X"FD"), To_StdLogicVector(X"02"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '0';

    ----------------------------------------------------------------
    -- sv_ge: Signed greater than or equal comparison
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_ge:"));
    writeline(output, L);

    write(L, string'("  2 >= 2 = "));
    sv_ge(To_StdLogicVector(X"02"), To_StdLogicVector(X"02"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '1';

    write(L, string'("  3 >= 2 = "));
    sv_ge(To_StdLogicVector(X"03"), To_StdLogicVector(X"02"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '1';

    write(L, string'("  2 >= -2 = "));
    sv_ge(To_StdLogicVector(X"02"), To_StdLogicVector(X"FE"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '1';

    write(L, string'("  -3 >= 2 = "));
    sv_ge(To_StdLogicVector(X"FD"), To_StdLogicVector(X"02"), svo);
    write(L, svo);
    writeline(output, L);
    assert svo = '0';

    ----------------------------------------------------------------
    ----------------------------------------------------------------
    --  Extension operators - convert a bit vector to a longer one
    ----------------------------------------------------------------
    ----------------------------------------------------------------

    ----------------------------------------------------------------
    -- sv_sext: Sign extension
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_sext:"));
    writeline(output, L);

    write(L, string'("  sext(X""02"", 32) = "));
    sv_sext(To_StdLogicVector(X"02"), svw, 32);
    write(L, svw, B, up);
    writeline(output, L);
    assert svw = To_StdLogicVector(X"00000002");

    write(L, string'("  sext(X""FE"", 32) = "));
    sv_sext(To_StdLogicVector(X"FE"),svw, 32);
    write(L, svw, B, up);
    writeline(output, L);
    assert svw = To_StdLogicVector(X"FFFFFFFE");

    write(L, string'("  sext(X""02"", 8) = "));
    sv_sext(To_StdLogicVector(X"02"), svb, 8);
    write(L, svb, B, up);
    writeline(output, L);
    assert svb = To_StdLogicVector(X"02");

    write(L, string'("  sext(X""FE"", 8) = "));
    sv_sext(To_StdLogicVector(X"FE"), svb, 8);
    write(L, svb, B, up);
    writeline(output, L);
    assert svb = To_StdLogicVector(X"FE");

    write(L, string'("  sext(X""02"", 4) = "));
    sv_sext(To_StdLogicVector(X"02"), svhb, 4);
    write(L, svhb, B, up);
    writeline(output, L);
    assert svhb = To_StdLogicVector(X"2");

    write(L, string'("  sext(X""FE"", 4) = "));
    sv_sext(To_StdLogicVector(X"FE"), svhb, 4);
    write(L, svhb, B, up);
    writeline(output, L);
    assert svhb = To_StdLogicVector(X"E");

    ----------------------------------------------------------------
    -- sv_zext: Zero extension
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_zext:"));
    writeline(output, L);

    write(L, string'("  sv_zext(X""02"", 32) = "));
    sv_zext(To_StdLogicVector(X"02"), svw, 32);
    write(L, svw, B, up);
    writeline(output, L);
    assert svw = To_StdLogicVector(X"00000002");

    write(L, string'(" sv_zext(X""FE"", 32) = "));
    sv_zext(To_StdLogicVector(X"FE"), svw, 32);
    write(L, svw, B, up);
    writeline(output, L);
    assert svw = To_StdLogicVector(X"000000FE");

    write(L, string'("  sv_zext(X""02"", 8) = "));
    sv_zext(To_StdLogicVector(X"02"), svb, 8);
    write(L, svb, B, up);
    writeline(output, L);
    assert svb = To_StdLogicVector(X"02");

    write(L, string'("  sv_zext(X""FE"", 8) = "));
    sv_zext(To_StdLogicVector(X"FE"), svb, 8);
    write(L, svb, B, up);
    writeline(output, L);
    assert svb = To_StdLogicVector(X"FE");

    write(L, string'("  sv_zext(X""02"", 4) = "));
    sv_zext(To_StdLogicVector(X"02"), svhb, 4);
    write(L, svhb, B, up);
    writeline(output, L);
    assert svhb = To_StdLogicVector(X"2");

    write(L, string'("  sv_zext(X""FE"", 4) = "));
    sv_zext(To_StdLogicVector(X"FE"), svhb, 4);
    write(L, svhb, B, up);
    writeline(output, L);
    assert svhb = To_StdLogicVector(X"E");

    ----------------------------------------------------------------
    -- sv_expand: value to vector expansion
    ----------------------------------------------------------------

    WAIT for 1 fs;

    writeline(output, L);
    write(L, string'("Testing sv_expand:"));
    writeline(output, L);

    write(L, string'("  sv_expand('1', 8) = "));
    write(L, sv_expand('1', 8), B, up);
    writeline(output, L);
    assert sv_expand('1', 8) = '1'&'1'&'1'&'1'&'1'&'1'&'1'&'1';

    write(L, string'("  sv_expand('W', 8) = "));
    write(L, sv_expand('W', 8), B, up);
    writeline(output, L);
    assert sv_expand('W', 8) = 'W'&'W'&'W'&'W'&'W'&'W'&'W'&'W';

    wait ; 
    end process;

end bench_2;
