--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  Partly derived from 
--   - DLX model suite
--     Copyright (C) 1993, Peter J. Ashenden
--     University of Adelaide, Australia / Dept. Computer Science
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Architecture for test bench for the new library functions
--  Testing write functions / logic functions / conversion functions
--
--  (file stdl1164_test-bench_1.vhd)
--------------------------------------------------------------------------

architecture bench_1 of stdl1164_test is
  
begin

  process

    variable L : line;
    variable sv1, sv2, sv3 : std_logic_vector(0 to 44);
    variable sv4, sv5 : std_logic_vector(0 to 11);
    variable sv6 : std_logic_vector(11 downto 0);

  begin
    
    ----------------------------------------------------------------
    -- test new write functions
    ----------------------------------------------------------------
    WAIT for 1 fs; 

    write(L, string'("Testing modified write functions:"));
    writeline(output, L);

    sv1 := "UUUUUUUUUXXXXXXXXX000000000111111111ZZZZZZZZZ";
    sv2 := "UX01ZWLH-UX01ZWLH-UX01ZWLH-UX01ZWLH-UX01ZWLH-";    
    write(L, sv2, X, up);
    writeline(output, L);
    write(L, sv2, O, up);
    writeline(output, L);
    write(L, sv2, B, up);
    writeline(output, L);

    sv4 := To_StdLogicVector(X"F52");
    write(L, sv4, X, up);
    writeline(output, L);
    sv4 := To_StdLogicVector(O"2736");
    write(L, sv4, O, up);
    writeline(output, L);
    sv4 := To_StdLogicVector(B"010110101100");
    write(L, sv4, B, up);
    writeline(output, L);

    sv6 := To_StdLogicVector(X"F52");
    write(L, sv6, X, down);
    writeline(output, L);
    sv6 := To_StdLogicVector(O"2736");
    write(L, sv6, O, down);
    writeline(output, L);
    sv6 := To_StdLogicVector(B"010110101100");
    write(L, sv6, B, down);
    writeline(output, L);

    ----------------------------------------------------------------
    -- test logic functions
    ----------------------------------------------------------------
    WAIT for 1 fs; 
 
    write(L, string'("Testing and-function:"));
    writeline(output, L);
    write(L, string'("     "));
    write(L, sv1, B, up);
    writeline(output, L);
    write(L, string'("and  "));
    write(L, sv2, B, up);
    writeline(output, L);
    write(L, string'("is   "));
    write(L, (sv1 and sv2), B, up);
    writeline(output, L);

    ----------------------------------------------------------------

    WAIT for 1 fs; 

    write(L, string'("Testing nand-function:"));
    writeline(output, L);
    write(L, string'("     "));
    write(L, sv1, B, up);
    writeline(output, L);
    write(L, string'("nand "));
    write(L, sv2, B, up);
    writeline(output, L);
    write(L, string'("is   "));
    write(L, (sv1 nand sv2), B, up);
    writeline(output, L);

    ----------------------------------------------------------------

    WAIT for 1 fs; 

    write(L, string'("Testing or-function:"));
    writeline(output, L);
    write(L, string'("     "));
    write(L, sv1, B, up);
    writeline(output, L);
    write(L, string'("or   "));
    write(L, sv2, B, up);
    writeline(output, L);
    write(L, string'("is   "));
    write(L, (sv1 or sv2), B, up);
    writeline(output, L);

    ----------------------------------------------------------------

    WAIT for 1 fs; 

    write(L, string'("Testing nor-function:"));
    writeline(output, L);
    write(L, string'("     "));
    write(L, sv1, B, up);
    writeline(output, L);
    write(L, string'("nor  "));
    write(L, sv2, B, up);
    writeline(output, L);
    write(L, string'("is   "));
    write(L, (sv1 nor sv2), B, up);
    writeline(output, L);

    ----------------------------------------------------------------

    WAIT for 1 fs; 

    write(L, string'("Testing xor-function:"));
    writeline(output, L);
    write(L, string'("     "));
    write(L, sv1, B, up);
    writeline(output, L);
    write(L, string'("xor  "));
    write(L, sv2, B, up);
    writeline(output, L);
    write(L, string'("is   "));
    write(L, (sv1 xor sv2), B, up);
    writeline(output, L);

    ----------------------------------------------------------------

--    WAIT for 1 fs; 
--
--    write(L, string'("Testing xnor-function:"));
--    writeline(output, L);
--    write(L, string'("     "));
--    write(L, sv1, B, up);
--    writeline(output, L);
--    write(L, string'("xnor "));
--    write(L, sv2, B, up);
--    writeline(output, L);
--    write(L, string'("is   "));
--    sv3 := xnor(sv1, sv2);
--    write(L, sv3, B, up);
--    writeline(output, L);

    ----------------------------------------------------------------

    WAIT for 1 fs; 

    write(L, string'("Testing not-function:"));
    writeline(output, L);
    write(L, string'("not  "));
    write(L, sv1, B, up);
    writeline(output, L);
    write(L, string'("is   "));
    write(L, (not sv1), B, up);
    writeline(output, L);

    ----------------------------------------------------------------
    -- test conversion functions
    ----------------------------------------------------------------
    
    WAIT for 1 fs;

    write(L, string'("Testing sv_to_natural:"));
    writeline(output, L);

    write(L, string'("  sv_to_natural(X""02"") = "));
    write(L, sv_to_natural(To_StdLogicVector(X"02")));
    writeline(output, L);
    assert sv_to_natural(To_StdLogicVector(X"02")) = 2;

    write(L, string'("  sv_to_natural(X""FE"") = "));
    write(L, sv_to_natural(To_StdLogicVector(X"FE")));
    writeline(output, L);
    assert sv_to_natural(To_StdLogicVector(X"FE")) = 254;

    write(L, string'("  sv_to_natural(""10001U11"") = "));
    write(L, sv_to_natural("10001U11"));
    writeline(output, L);
    assert sv_to_natural("10001U11") = 0;

    ----------------------------------------------------------------
    
    WAIT for 1 fs;

    write(L, string'("Testing natural_to_sv:"));
    writeline(output, L);

    write(L, string'("  natural_to_sv(2) = "));
    write(L, natural_to_sv(2, 8), B, up);
    writeline(output, L);
    assert natural_to_sv(2, 8) = To_StdLogicVector(X"02");

    write(L, string'("  natural_to_sv(254) = "));
    write(L, natural_to_sv(254, 8), B, up);
    writeline(output, L);
    assert natural_to_sv(254, 8) = To_StdLogicVector(X"FE");

    ----------------------------------------------------------------
    
    WAIT for 1 fs;

    write(L, string'("Testing sv_to_integer:"));
    writeline(output, L);

    write(L, string'("  sv_to_integer(X""02"") = "));
    write(L, sv_to_integer(To_StdLogicVector(X"02")));
    writeline(output, L);
    assert sv_to_integer(To_StdLogicVector(X"02")) = 2;

    write(L, string'("  sv_to_integer(X""FE"") = "));
    write(L, sv_to_integer(To_StdLogicVector(X"FE")));
    writeline(output, L);
    assert sv_to_integer(To_StdLogicVector(X"FE")) = -2;

    write(L, string'("  sv_to_integer(""10001X11"") = "));
    write(L, sv_to_integer("10001X11"));
    writeline(output, L);
    assert sv_to_integer("10001X11") = 0;

    ----------------------------------------------------------------
    
    WAIT for 1 fs;

    write(L, string'("Testing integer_to_sv:"));
    writeline(output, L);

    write(L, string'("  integer_to_sv(2) = "));
    write(L, integer_to_sv(2, 8), B, up);
    writeline(output, L);
    assert integer_to_sv(2, 8) = To_StdLogicVector(X"02");

    write(L, string'("  integer_to_sv(-2) = "));
    write(L, integer_to_sv(-2, 8), B, up);
    writeline(output, L);
    assert integer_to_sv(-2, 8) = To_StdLogicVector(X"FE");


    wait ; 
    end process;

end bench_1;




