--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  Partly derived from 
--   - DLX model suite
--     Copyright (C) 1993, Peter J. Ashenden
--     University of Adelaide, Australia / Dept. Computer Science
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Package declaration for the extended functions to the IEEE_1164 logic  
--  
--  (file stdl1164_extended.vhd)
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

--synopsys synthesis_off
use STD.textio.all;
--synopsys synthesis_on

PACKAGE stdl1164_extended IS
--synopsys synthesis_off
    -------------------------------------------------------------------    
    -- object contains only '1' or 'H' 
    -------------------------------------------------------------------    
    FUNCTION Is_1H ( s : std_ulogic_vector ) RETURN  BOOLEAN;
    FUNCTION Is_1H ( s : std_logic_vector  ) RETURN  BOOLEAN;
    FUNCTION Is_1H ( s : std_ulogic        ) RETURN  BOOLEAN;

    -------------------------------------------------------------------    
    -- object contains only '0' or 'L'
    -------------------------------------------------------------------    
    function Is_0L ( s : std_ulogic_vector ) RETURN  BOOLEAN;
    function Is_0L ( s : std_logic_vector  ) RETURN  BOOLEAN;
    function Is_0L ( s : std_ulogic        ) RETURN  BOOLEAN;

    -------------------------------------------------------------------    
    -- type declarations for modified write functions
    -------------------------------------------------------------------
    type outmode is (X, O, B);    
    type orientation is (up, down);   

    -------------------------------------------------------------------    
    -- modified write functions
    -------------------------------------------------------------------
    procedure write (l: INOUT LINE; value: IN std_ulogic);
    procedure write (l: INOUT LINE; value: IN std_logic_vector; 
                     mode: IN outmode; orient: IN orientation);
    procedure write (l: INOUT LINE; value: IN std_ulogic_vector;
                     mode: IN outmode; orient: IN orientation); 

--synopsys synthesis_on
END stdl1164_extended;






