--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  Partly derived from 
--   - DLX model suite
--     Copyright (C) 1993, Peter J. Ashenden
--     University of Adelaide, Australia / Dept. Computer Science
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Package body for the std_logic extended functions
--  
--  (file stdl1164_extended-body.vhd)
--------------------------------------------------------------------------

PACKAGE BODY stdl1164_extended IS
--synopsys synthesis_off
    -------------------------------------------------------------------    
    -- object contains only '1' or 'H' 
    -------------------------------------------------------------------    
    FUNCTION Is_1H ( s : STD_ULOGIC_VECTOR ) RETURN  BOOLEAN IS
    BEGIN
        FOR i IN s'RANGE LOOP
            CASE s(i) IS
                WHEN 'U' | 'X' | 'Z' | 'W' | '-' | '0' | 'L' => RETURN FALSE;
                WHEN OTHERS => NULL;
            END CASE;
        END LOOP;
        RETURN TRUE;
    END;

    --------------------------------------------------------------------
    FUNCTION Is_1H ( s : STD_LOGIC_VECTOR  ) RETURN  BOOLEAN IS
    BEGIN
        FOR i IN s'RANGE LOOP
            CASE s(i) IS
                WHEN 'U' | 'X' | 'Z' | 'W' | '-' | '0' | 'L' => RETURN FALSE;
                WHEN OTHERS => NULL;
            END CASE;
        END LOOP;
        RETURN TRUE;
    END;
    --------------------------------------------------------------------

    FUNCTION Is_1H ( s : STD_ULOGIC        ) RETURN  BOOLEAN IS
    BEGIN
        CASE s IS
            WHEN '1' | 'H' => RETURN TRUE;
            WHEN OTHERS => RETURN FALSE;
        END CASE;
    END;

    -------------------------------------------------------------------    
    -- object contains only '0' or 'L'
    -------------------------------------------------------------------    

    FUNCTION Is_0L ( s : STD_ULOGIC_VECTOR ) RETURN  BOOLEAN IS
    BEGIN
        FOR i IN s'RANGE LOOP
            CASE s(i) IS
                WHEN 'U' | 'X' | 'Z' | 'W' | '-' | '1' | 'H' => RETURN FALSE;
                WHEN OTHERS => NULL;
            END CASE;
        END LOOP;
        RETURN TRUE;
    END;
    --------------------------------------------------------------------

    FUNCTION Is_0L ( s : STD_LOGIC_VECTOR  ) RETURN  BOOLEAN IS
    BEGIN
        FOR i IN s'RANGE LOOP
            CASE s(i) IS
                WHEN 'U' | 'X' | 'Z' | 'W' | '-' | '1' | 'H' => RETURN FALSE;
                WHEN OTHERS => NULL;
            END CASE;
        END LOOP;
        RETURN TRUE;
    END;
    --------------------------------------------------------------------

    FUNCTION Is_0L ( s : STD_ULOGIC        ) RETURN  BOOLEAN IS
    BEGIN
        CASE s IS
            WHEN '0' | 'L' => RETURN TRUE;
            WHEN OTHERS => RETURN FALSE;
        END CASE;
        RETURN TRUE;
    END;

    -------------------------------------------------------------------    
    -- adapted write procedures
    -------------------------------------------------------------------    

    procedure write (l: INOUT LINE; value: IN std_ulogic) is

    variable temp : CHARACTER;
    begin
      case value is
         when 'U' => temp := 'U';
         when 'X' => temp := 'X';
         when '1' => temp := '1';
         when '0' => temp := '0';
         when 'Z' => temp := 'Z';
         when 'W' => temp := 'W';
         when 'L' => temp := 'L';
         when 'H' => temp := 'H';
         when '-' => temp := '-';
       end case;
       write (l, temp);
     end write;

   --------------------------------------------------------------------
   procedure write (l: INOUT LINE; value: IN std_ulogic_vector; 
                    mode : IN outmode; orient: IN orientation) is

    constant vlength : natural := value'length;
    variable temp : CHARACTER;
    variable temp_int, head, count, head_len, tmp_cnt: NATURAL;
    variable norm_value : std_ulogic_vector(1 to vlength) := value;
    variable vector_bit : std_ulogic;

    begin
      case mode is

	when B => 
	  write (l, '"');
          head := vlength mod 4;  
          for count in 1 to vlength loop
            if ( (head = 0) and ( count /= 1)) then write (l, '_'); end if; 
	    case norm_value(count) is
	      when 'U' => temp := 'U';
	      when 'X' => temp := 'X';
	      when '1' => temp := '1';
	      when '0' => temp := '0';
	      when 'Z' => temp := 'Z';
              when 'W' => temp := 'W';
              when 'L' => temp := 'L';
              when 'H' => temp := 'H';
              when '-' => temp := '-';
	    end case;
	    write (l, temp);
	    if ( head = 0 ) then head := 3; else head := head - 1; end if;
	  end loop;
	
	when X | O => 
	  if ( mode = X ) then
	    write (l, STRING'("X"""));
	    head_len := 4;
	  else
	    write (l, STRING'("O"""));
	    head_len := 3;
	  end if;
	  head := vlength mod head_len;

          while (count < vlength) loop
	    temp_int := 0;
	    temp := '0';

	    for j in 1 to head loop

              if (orient = up) then
	        vector_bit := value(count);
	      elsif (orient = down) then
	        tmp_cnt := vlength-count-1;
 	        vector_bit := value(tmp_cnt);
 	      end if;

	      case vector_bit is
		when 'U' => temp := 'U';
		when 'X' | 'Z' | 'W' | '-' => if ( temp /= 'U') then temp := 'X'; end if;
		when '1' | 'H' => temp_int := 2*temp_int + 1;
		when '0' | 'L' => temp_int := 2*temp_int;
	      end case;
	      count := count + 1;
	    end loop;

	    if ( (temp /= 'X') AND (temp /= 'U')) then
	      if (temp_int < 10) then
		temp := CHARACTER'VAL(temp_int + 48);
	      else
		temp := CHARACTER'VAL(temp_int + 55);
	      end if;
	    end if;

	    if (count  /= 0) then write (l, temp); end if;	
	    head := head_len; 
	  end loop;

      end case;
      write (l, '"');
    end write;

   --------------------------------------------------------------------
   procedure write (l: INOUT LINE; value: IN std_logic_vector; 
                    mode : IN outmode; orient: IN orientation) is

    constant vlength : natural := value'length;
    variable temp : CHARACTER;
    variable temp_int, head, count, head_len, tmp_cnt: NATURAL;
    variable norm_value : std_logic_vector(1 to vlength) := value;
    variable vector_bit : std_logic;

    begin
      case mode is

	when B => 
	  write (l, '"');
          head := vlength mod 4;  
          for count in 1 to vlength loop
            if ( (head = 0) and ( count /= 1)) then write (l, '_'); end if; 
	    case norm_value(count) is
	      when 'U' => temp := 'U';
	      when 'X' => temp := 'X';
	      when '1' => temp := '1';
	      when '0' => temp := '0';
	      when 'Z' => temp := 'Z';
              when 'W' => temp := 'W';
              when 'L' => temp := 'L';
              when 'H' => temp := 'H';
              when '-' => temp := '-';
	    end case;
	    write (l, temp);
	    if ( head = 0 ) then head := 3; else head := head - 1; end if;
	  end loop;
	
	when X | O => 
	  if ( mode = X ) then
	    write (l, STRING'("X"""));
	    head_len := 4;
	  else
	    write (l, STRING'("O"""));
	    head_len := 3;
	  end if;
	  head := vlength mod head_len;

          while (count < vlength) loop
	    temp_int := 0;
	    temp := '0';
	    for j in 1 to head loop

              if (orient = up) then
	        vector_bit := value(count);
	      elsif (orient = down) then
	        tmp_cnt := vlength-count-1;
 	        vector_bit := value(tmp_cnt);
              end if;

	      case vector_bit is
		when 'U' => temp := 'U';
		when 'X' | 'Z' | 'W' | '-' => if ( temp /= 'U') then temp := 'X'; end if;
		when '1' | 'H' => temp_int := 2*temp_int + 1;
		when '0' | 'L' => temp_int := 2*temp_int;
	      end case;

	      count := count + 1;
	    end loop;

	    if ( (temp /= 'X') AND (temp /= 'U')) then
	      if (temp_int < 10) then
		temp := CHARACTER'VAL(temp_int + 48);
	      else
		temp := CHARACTER'VAL(temp_int + 55);
	      end if;
	    end if;
	    if (count  /= 0) then write (l, temp); end if;	
	    head := head_len; 
	  end loop;

      end case;
      write (l, '"');
    end write;

--synopsys synthesis_on
END stdl1164_extended;











