--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  entity declaration of the timer module
--  
--  (file timer.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- programming model of the timer module:
--
-- address 0 : timer status word (32 bit)
-- address 4 : counter_0 (16 bit downcount) read/write
-- address 8 : counter_1 (16 bit downcount) read/write
--
-- counter:  address  | address+1 | address+2 | address+3 |
--           ----------------------------------------------
--           high byte| low byte  |      (unused)         |
--
-- timer status word:
-- 
-- --------------------------------------------------------------------
-- Bit no.  |   0   |   1   |  2  |  3  |  4   |  5   |  6   |   7    |
-- function |intrpt0|intrpt1|mask0|mask1|count0|count1|double|sync_res|
-- --------------------------------------------------------------------
-- Bit no.  |            8  -  15   (8 bit value for n)               |
-- function |        delay every count event by n clock cycles        |
-- --------------------------------------------------------------------
-- Bit no.  |                    16 -  31                             |
-- function |                    (unused)                             |
-- --------------------------------------------------------------------
--
-- intrptx : '1': if interrupt has occurred after last reset
--                (must be cleared to reactivate interrupt outputs)
-- maskx   : '1': enable interrup output x (active when counter x is zero)
-- countx  : '1': enable counting for counter x (must be zero when loading)
-- double  : '1': connect counter 0 and 1
--                (counter 1 is high word of 64 bit counter)
-- sync_res: '1': reset all registers synchronous with next clock cycle
--
-- irq_out(0) : '1' if counter_0 becomes zero and interrupt 0 is enabled
--              or
--              '1' if counter_1 & counter_0 become zero and interrupt 0
--              is enabled
-- irq_out(1) : '1' if counter_1 becomes zero and interrupt 1 is enabled
--------------------------------------------------------------------------

library IEEE;
USE IEEE.std_logic_1164.ALL;
library IEEE_EXTD;
use IEEE_EXTD.stdl1164_extended.all,
    IEEE_EXTD.stdl1164_vector_arithmetic.all;
library DLX;
use DLX.dlx_types.all;

entity timer is
  generic (tpd : Time);		                  -- clock to output delay
  port (a_bus : in std_logic_vector(3 downto 2);  -- select between 3
       	d_bus  : inout dlx_half bus;              --  32(16) bit registers
        clk    : in std_logic;
        enable : in std_logic;
        rw     : in std_logic;
	reset  : in std_logic;
        ready  : out std_logic;
	irq_out: out std_logic_vector(0 to 1) );
end timer;





