--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Architecture for the test bench for rom module 
--  
--  (file rom_test-bench.vhd)
--------------------------------------------------------------------------

ARCHITECTURE bench OF rom_test IS

  COMPONENT rom
    PORT (a_bus : in std_logic_vector(15 downto 0);
          d_bus : inout dlx_word bus;
 	  enable: in std_logic;
   	  ready : out std_logic);
  END COMPONENT;
  
  signal a : dlx_address;
  SIGNAL d : dlx_word;
  signal en_sig: std_logic;
  signal rdy_sig : std_logic;

  constant tpd_bench : Time := 1 ns;
  
BEGIN

  testrom : rom
    PORT MAP (a_bus => a(15 downto 0), d_bus => d,
              enable => en_sig, ready => rdy_sig);
    
  test: process
    variable add_w : dlx_address;
    variable data_w : dlx_word;
    variable address : natural := 0;
    variable L : line;

    procedure mem_read (adr  : in dlx_address;
		        data : out dlx_word) is
    begin -- read
      a <= adr after tpd_bench;
      en_sig <= '1' after tpd_bench;
      wait until rdy_sig = '1';		-- wait until data is ready
      data := d;
      en_sig <= '0' after tpd_bench;
      wait until rdy_sig = 'Z';		-- wait until ram is idle again
    end mem_read;

  begin		-- read out all ram data
    -------------------------------------------------------------------------
    wait until rdy_sig = 'Z';

    loop 
      add_w := natural_to_sv(address, 32);
      --
      -- read word from rom
      --
      write(L, string'("Read word from address "));
      write(L, add_w, X, down);
      writeline(output, L);
      data_w := To_StdLogicVector(X"0000_0000");
      mem_read(add_w, data_w);
      --
      -- write out result
      --
      write(L, string'("  result:"));
      write(L, data_w, X, up);
      writeline(output, L);
      exit when Is_X(data_w);
      --
      -- write out decoded instruction
      --
      write_instr(L, data_w);
      writeline(output, L);
      write(L, string'("-----------------------------"));
      writeline(output, L);
      --
      -- increment address pointer
      --
      address := address + 4;
      exit when address = 16#10000#;
    end loop;    

  end process test;

END bench;
