--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for the rom
--  
--  (file rom.vhd)
--------------------------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
library IEEE_EXTD;
USE IEEE_EXTD.stdl1164_extended.all,
    IEEE_EXTD.stdl1164_vector_arithmetic.all;
library DLX;
USE DLX.dlx_types.all;

entity rom is
  generic (tpd : Time;			-- signal to output delay
           tac : Time);			-- Access time to and from memory
  port (a_bus  : in  std_logic_vector(15 downto 0);
        d_bus  : out dlx_word bus;
        enable : in  std_logic;
        ready  : out std_logic);
end rom;




