--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Architecture declaration for the rom
--    generated by the DLX_ASM assembler v1.0
--    (C) v1.1 M.Gumm / (C) v0.1 P. Bazrgan Sabet
--
--  (input file: intrpt1.asm)
--  (vhdl file : rom-behaviour_intrpt1.vhd)
--------------------------------------------------------------------------

architecture behaviour_intrpt1 of rom is

begin
 
-- word addressable rom (size 64Kbyte : 16 bit address)
 
  process
    variable address : natural;
  begin
    --
    -- initialize outputs
    --
    d_bus <= (others => 'Z') after tpd;
    ready <= 'Z' after tpd;
      --
      -- wait until rom is enabled
      --
      wait until Is_1H(enable);
      ready <= '0' after tpd;
      --
      -- decode address and perform command if selected
      --
      address := sv_to_natural(a_bus);
      wait for tac; 			-- read access time
      case address is
        when 16#0000# => d_bus <= To_StdLogicVector(X"4c002000");
        when 16#0004# => d_bus <= To_StdLogicVector(X"501d0040");
        when 16#0008# => d_bus <= To_StdLogicVector(X"4c002100");
        when 16#000c# => d_bus <= To_StdLogicVector(X"501d0100");
        when 16#0010# => d_bus <= To_StdLogicVector(X"4c002200");
        when 16#0014# => d_bus <= To_StdLogicVector(X"4c002300");
        when 16#0018# => d_bus <= To_StdLogicVector(X"4c002400");
        when 16#001c# => d_bus <= To_StdLogicVector(X"50040001");
        when 16#0020# => d_bus <= To_StdLogicVector(X"00002808");
        when 16#0024# => d_bus <= To_StdLogicVector(X"00a42804");
        when 16#0028# => d_bus <= To_StdLogicVector(X"33fffff8");
        when others   => d_bus <= (others => 'X');
      end case;
      ready <= '1' after tpd;
      --
      -- wait for acceptance of data
      --
      wait until Is_0L(enable);
 
  end process;
 
end behaviour_intrpt1;
