--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Architecture declaration for the rom
--    generated by the DLX_ASM assembler v1.0
--    (C) v1.1 M.Gumm / (C) v0.1 P. Bazrgan Sabet
--
--  (input file: except.asm)
--  (vhdl file : rom-behaviour_except.vhd)
--------------------------------------------------------------------------

architecture behaviour_except of rom is

begin
 
-- word addressable rom (size 64Kbyte : 16 bit address)
 
  process
    variable address : natural;
  begin
    --
    -- initialize outputs
    --
    d_bus <= (others => 'Z') after tpd;
    ready <= 'Z' after tpd;
      --
      -- wait until rom is enabled
      --
      wait until Is_1H(enable);
      ready <= '0' after tpd;
      --
      -- decode address and perform command if selected
      --
      address := sv_to_natural(a_bus);
      wait for tac; 			-- read access time
      case address is
        when 16#0000# => d_bus <= To_StdLogicVector(X"50140003");
        when 16#0004# => d_bus <= To_StdLogicVector(X"3a800000");
        when 16#0008# => d_bus <= To_StdLogicVector(X"3e800000");
        when 16#000c# => d_bus <= To_StdLogicVector(X"30009875");
        when 16#0010# => d_bus <= To_StdLogicVector(X"37ffffff");
        when 16#0014# => d_bus <= To_StdLogicVector(X"40002345");
        when 16#0018# => d_bus <= To_StdLogicVector(X"468000ff");
        when 16#001c# => d_bus <= To_StdLogicVector(X"4fff7777");
        when 16#0020# => d_bus <= To_StdLogicVector(X"6c149000");
        when 16#0024# => d_bus <= To_StdLogicVector(X"66940000");
        when 16#0028# => d_bus <= To_StdLogicVector(X"5015ffff");
        when 16#002c# => d_bus <= To_StdLogicVector(X"50010001");
        when 16#0030# => d_bus <= To_StdLogicVector(X"50020002");
        when 16#0034# => d_bus <= To_StdLogicVector(X"50050005");
        when 16#0038# => d_bus <= To_StdLogicVector(X"50060006");
        when 16#003c# => d_bus <= To_StdLogicVector(X"12960002");
        when 16#0040# => d_bus <= To_StdLogicVector(X"16960001");
        when 16#0044# => d_bus <= To_StdLogicVector(X"22950006");
        when 16#0048# => d_bus <= To_StdLogicVector(X"26950005");
        when 16#004c# => d_bus <= To_StdLogicVector(X"0282b020");
        when 16#0050# => d_bus <= To_StdLogicVector(X"0281b021");
        when 16#0054# => d_bus <= To_StdLogicVector(X"0286a828");
        when 16#0058# => d_bus <= To_StdLogicVector(X"0285a829");
        when 16#005c# => d_bus <= To_StdLogicVector(X"6c018000");
        when 16#0060# => d_bus <= To_StdLogicVector(X"6c02ffff");
        when 16#0064# => d_bus <= To_StdLogicVector(X"6442ffff");
        when 16#0068# => d_bus <= To_StdLogicVector(X"50030001");
        when 16#006c# => d_bus <= To_StdLogicVector(X"00222804");
        when 16#0070# => d_bus <= To_StdLogicVector(X"5025ffff");
        when 16#0074# => d_bus <= To_StdLogicVector(X"00232806");
        when 16#0078# => d_bus <= To_StdLogicVector(X"58250001");
        when 16#007c# => d_bus <= To_StdLogicVector(X"00000000");
        when 16#0080# => d_bus <= To_StdLogicVector(X"50010001");
        when 16#0084# => d_bus <= To_StdLogicVector(X"33ff0000");
        when 16#0088# => d_bus <= To_StdLogicVector(X"37ff0000");
        when 16#008c# => d_bus <= To_StdLogicVector(X"38000000");
        when 16#0090# => d_bus <= To_StdLogicVector(X"3c000000");
        when 16#0094# => d_bus <= To_StdLogicVector(X"40008000");
        when 16#0098# => d_bus <= To_StdLogicVector(X"44208000");
        when 16#009c# => d_bus <= To_StdLogicVector(X"6c141000");
        when 16#00a0# => d_bus <= To_StdLogicVector(X"66940000");
        when 16#00a4# => d_bus <= To_StdLogicVector(X"5015ffff");
        when 16#00a8# => d_bus <= To_StdLogicVector(X"50010001");
        when 16#00ac# => d_bus <= To_StdLogicVector(X"50020002");
        when 16#00b0# => d_bus <= To_StdLogicVector(X"50030004");
        when 16#00b4# => d_bus <= To_StdLogicVector(X"12960000");
        when 16#00b8# => d_bus <= To_StdLogicVector(X"16960002");
        when 16#00bc# => d_bus <= To_StdLogicVector(X"1a960001");
        when 16#00c0# => d_bus <= To_StdLogicVector(X"22950004");
        when 16#00c4# => d_bus <= To_StdLogicVector(X"26950006");
        when 16#00c8# => d_bus <= To_StdLogicVector(X"2a950007");
        when 16#00cc# => d_bus <= To_StdLogicVector(X"0283b020");
        when 16#00d0# => d_bus <= To_StdLogicVector(X"0282b021");
        when 16#00d4# => d_bus <= To_StdLogicVector(X"0281b022");
        when 16#00d8# => d_bus <= To_StdLogicVector(X"0283a828");
        when 16#00dc# => d_bus <= To_StdLogicVector(X"0282a829");
        when 16#00e0# => d_bus <= To_StdLogicVector(X"0281a82a");
        when 16#00e4# => d_bus <= To_StdLogicVector(X"00200802");
        when 16#00e8# => d_bus <= To_StdLogicVector(X"00800803");
        when 16#00ec# => d_bus <= To_StdLogicVector(X"48000000");
        when 16#00f0# => d_bus <= To_StdLogicVector(X"33fffffc");
        when others   => d_bus <= (others => 'X');
      end case;
      ready <= '1' after tpd;
      --
      -- wait for acceptance of data
      --
      wait until Is_0L(enable);
 
  end process;
 
end behaviour_except;
