--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Behaviour architecture of the byte_ram module
--  
--  (file ram_byte-behaviour.vhd)
--------------------------------------------------------------------------

architecture behaviour of ram_byte is
  
begin

  memory : process 

    constant low_adr : natural := 0;
    constant high_adr : natural := b_mem_size - 1;
    type memory_array is array (low_adr to high_adr) of dlx_byte;
    variable mem : memory_array;
    variable address : natural;

  begin
    --
    -- initialize outputs
    --
    b_d_bus <= (others => 'Z') after b_tpd;
    b_ready <= '0' after b_tpd;
      -- 
      -- wait until ram is enabled
      --
      wait until Is_1H(b_enable);
      --
      -- decode address and perform command if selected
      --
      address := sv_to_natural(b_a_bus);
      if address >= low_adr and address <= high_adr then
        if Is_0L(b_rw) then 				-- write cycle
          mem(address)  := b_d_bus(0 to 7);
          wait for b_tac;  				-- write access time
          b_ready <= '1' after b_tpd;
        elsif Is_1H(b_rw) then				-- read cycle
          wait for b_tac;  				-- read access time
          b_d_bus <= mem(address);
          b_ready <= '1' after b_tpd;
        else
          assert FALSE
          report "byte_ram: RW line undefined"
          severity warning;
        end if;
      else
        assert FALSE
          report "byte_ram: memory access to undefined memory region"
          severity warning;
      end if;
      --
      -- wait for acceptance of data
      --
      wait until Is_0L(b_enable);
   
  end process;

end behaviour;






