--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Structural architecture of the ram module
--  
--  (file ram-structural.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--
--  DLX - Word (32 bit / Big Endian)
-- ----------------------------------
--  Bit  | 0  1  ... 7 | 8  9  ... 15 | 16  17  ... 23 | 24 25 ... 31 |
--        MSB                                                      LSB
--
--  Memory
-- --------
--  Adr       xxx00         xxx01           xxx02           xxx03        
--  Byte	No. 0	      No. 1	      No. 2	      No. 3
--  Bit  | 0  1  ... 7 | 0  1  ...  7 |  0  1   ...  7 |  0  1 ...  7 |
--
--------------------------------------------------------------------------

architecture structural of ram is
  
  component ram_byte
    port (b_a_bus : in std_logic_vector(15 downto 2);
          b_d_bus : inout dlx_byte bus;
	  b_enable: in std_logic;
          b_rw    : in std_logic;
   	  b_ready : out std_logic);
  end component;

begin

  bank_0 : ram_byte
    port map (b_a_bus => a_bus(15 downto 2), b_d_bus => d_bus(0 to 7),
              b_enable => enable(0), b_rw => rw, b_ready => ready(0));
  bank_1 : ram_byte
    port map (b_a_bus => a_bus(15 downto 2), b_d_bus => d_bus(8 to 15), 
              b_enable => enable(1), b_rw => rw, b_ready => ready(1));
  bank_2 : ram_byte
    port map (b_a_bus => a_bus(15 downto 2), b_d_bus => d_bus(16 to 23), 
              b_enable => enable(2), b_rw => rw, b_ready => ready(2));
  bank_3 : ram_byte
    port map (b_a_bus => a_bus(15 downto 2), b_d_bus => d_bus(24 to 31), 
              b_enable => enable(3), b_rw => rw, b_ready => ready(3));
  
end structural;





