--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- Configuration for the test bench for the clock generator
--  
--  (file clockgen_test-config-1.vhd)
--------------------------------------------------------------------------

CONFIGURATION clockgen_test_cfg1 OF clockgen_test IS
  --
  -- Choose an architecture for the test-bench entity "clockgen_test"
  -- The name of the chosen architecture is "bench"
  --
  FOR bench
    --
    -- Choose an entity for the component declared in the testbench-
    -- architecture (the chosen entity is "clockgen").
    -- Choose an architecture for the instantiated entity (the chosen entity
    -- is "dataflow").
    FOR cg : clockgen
      USE ENTITY WORK.clockgen(dataflow)
        -- Assign values for the generic parameters of the entity "clockgen"
        -- (this defines the generated clock signal)
        --
        GENERIC MAP (tpw => 8 ns, tps => 2 ns);
    END FOR;
    
  END FOR;
  
END clockgen_test_cfg1;








