--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Dataflow architecture of clock generator 
--  
--  (file clockgen-dataflow.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- How to generate a two-phase, non-overlapping clock signal with
-- VDHL concurrent statements statements
--
-- Internal signal phia toggles every half clock periode.
-- Internal signal phib follows phia after the clock-pulse width.
-- Output signals phi1 and phi2 are results of
-- logic functions of phia and phib.
--                                    ____      ____      ____      __
--                               phia    :|____|    |____|    |____|
--                                       :____      ____      ____  
--                               phib ___|    |____|    |____|    |___
--                                    tpw:
-- 	                              ___       ___       ___      __ 
-- phi1 <= phia and (not phib)   phi1    |_____|   |_____|   |_____|
--                                         ___       ___       ___
-- phi2 <= (not phia) and phib   phi2 ____|   |_____|   |_____|   |___
--
--------------------------------------------------------------------------

ARCHITECTURE dataflow OF clockgen IS

  CONSTANT clock_period : TIME := 2*(tpw+tps);   -- length of one periode
  SIGNAL phia : std_logic := '1';                -- internal signal 
  SIGNAL phib : std_logic := '0';                -- internal signal
   
BEGIN

  reset_driver: 
    reset <= '1',
             '0' AFTER 2*clock_period + tpw+tps;

  internal_signals:
    phia <= NOT phia AFTER (tpw+tps);
    phib <= phia AFTER tpw;

  generated_signals:
    phi1 <= phia AND NOT phib;
    phi2 <= NOT phia AND phib;

END dataflow;



