--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- Behavioural architecture body for clock generator
--
-- (file clockgen-behaviour.vhd)
--------------------------------------------------------------------------

ARCHITECTURE behaviour OF clockgen IS

  CONSTANT clock_period : TIME := 2*(tpw+tps);    -- length of one period

BEGIN

  reset_driver: 
    reset <= '1',
             '0' AFTER 2*clock_period + tpw+tps;

  clock_driver : PROCESS
  BEGIN
    phi1 <= '1',
            '0' AFTER tpw;
    phi2 <= '1' AFTER tpw+tps,
            '0' AFTER tpw+tps+tpw;
    WAIT FOR clock_period;
  END PROCESS clock_driver;
  
END behaviour;
