--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Dataflow architecture of shifter (barrel shifter)
--
--  file word_shifter-barrel.vhd
--------------------------------------------------------------------------

architecture barrel of word_shifter is
  signal buf_0, buf_1, buf_2, buf_3 : dlx_word;
  signal op0, op1, op2,op3, op4: std_logic_vector(0 to 2);
begin
  op0 <= shift(0) & lr_switch & ar_switch;
  op1 <= shift(1) & lr_switch & ar_switch;
  op2 <= shift(2) & lr_switch & ar_switch;
  op3 <= shift(3) & lr_switch & ar_switch;
  op4 <= shift(4) & lr_switch & ar_switch;

  with op0 select
    buf_0(0 to 31) <=
      a(0 to 31) when "000" | "001" | "010" | "011",
      a(1 to 31) & '0' when "100" | "101",
      '0' & a(0 to 30) when "110",
      a(0) & a(0 to 30) when "111",
      "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" when others;

  with op1 select
    buf_1(0 to 31) <=
      buf_0(0 to 31) when "000" | "001" | "010" | "011",
      buf_0(2 to 31) & "00" when "100" | "101",
      "00" & buf_0(0 to 29) when "110",
      buf_0(0) & buf_0(0) & buf_0(0 to 29) when "111",
      "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" when others;

  with op2 select
    buf_2(0 to 31) <=
      buf_1(0 to 31) when "000" | "001" | "010" | "011",
      buf_1(4 to 31) & "0000" when "100" | "101",
      "0000" & buf_1(0 to 27) when "110",
      buf_1(0) & buf_1(0) & buf_1(0) & buf_1(0) &
        buf_1(0 to 27) when "111",
      "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" when others;

  with op3 select
    buf_3(0 to 31) <=
      buf_2(0 to 31) when "000" | "001" | "010" | "011",
      buf_2(8 to 31) & "00000000" when "100" | "101",
      "00000000" & buf_2(0 to 23) when "110",
      buf_2(0) & buf_2(0) & buf_2(0) & buf_2(0) &
      buf_2(0) & buf_2(0) & buf_2(0) & buf_2(0) & 
        buf_2(0 to 23) when "111",
      "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" when others;

  with op4 select
    b(0 to 31) <=
      buf_3(0 to 31) when "000" | "001" | "010" | "011",
      buf_3(16 to 31) & "0000000000000000" when "100" | "101",
      "0000000000000000" & buf_3(0 to 15) when "110",
      buf_3(0) & buf_3(0) & buf_3(0) & buf_3(0) &
      buf_3(0) & buf_3(0) & buf_3(0) & buf_3(0) & 
      buf_3(0) & buf_3(0) & buf_3(0) & buf_3(0) &
      buf_3(0) & buf_3(0) & buf_3(0) & buf_3(0) & 
      buf_3(0 to 15) when "111",
      "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" when others;    

end barrel;




