--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  dataflow descrition of the alu logic
--  
--  (file word_alu_logic-behaviour.vhd)
--------------------------------------------------------------------------

architecture behaviour of word_alu_logic is
begin
  the_logic_func : process(a, b, sel)
  begin
    case sel is
      when "00" =>
	y <= a and b after tpd_out;
      when "01" =>
	y <= a or b after tpd_out;
      when "10" | "11" =>
	y <= a xor b after tpd_out;
      when others => 
	y <= (others => 'X') after tpd_out;
    end case;
  end process the_logic_func;
 
end behaviour;
