--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for in/out pad
--  
--  (file pad_io.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- io_sel : '0' -> output / '1' -> input (tristate when pad is read)
--------------------------------------------------------------------------

library IEEE;
USE IEEE.std_logic_1164.ALL;

entity pad_io is
  generic (tpd_c2p, tpd_p2c : Time;
           t_switch : Time);
  port (io_sel : in std_logic;   
        pad    : inout std_logic;           -- pad out
        pad2core : out std_logic;           -- from pad to core
	core2pad : in  std_logic);          -- from core to pad
end pad_io;
