--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for memory data register (32-bit)
--  with one tri-state output an one normal output
--  (register with special shift capabilities)
--
--  (file mdr.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  out_en   : low active
--  latch_en : low active
--------------------------------------------------------------------------
-- mdr shift control signals shift_ctrl(0 to2)
--     "0--" load/store word
--     "100" load half 
--     "101" load byte 
--     "110" store half
--     "111" store byte
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

use WORK.dlx_types.all;

entity mdr is
  generic (tpd_latch, tpd_out, tpd_logic : Time);
  port (d      : in dlx_word;
	q1, q2 : out dlx_word;
	latch_en : in std_logic;
	out_en1  : in std_logic;
	shift_ctrl : in std_logic_vector(0 to 2);
        mar_ls2_in : in std_logic_vector(0 to 1));
end mdr;





