--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Behavioural architecture for the instruction decoder 2
--
--  file ir_decode_2-behaviour.vhd
--------------------------------------------------------------------------

architecture behaviour of ir_decode_2 is

begin
  decode_2 : process(instr_in)
  begin
    case instr_in(0 to 5) is
      when op_rr_alu =>
	case instr_in(26 to 31) is
          when rr_func_lw =>
	    dec2_out <= load_w_1 after tpd_dec;
	    mdr_ctrl_out <= mdr_ctrl_none after tpd_dec;
          when rr_func_lh =>
	    dec2_out <= load_h_1 after tpd_dec;
	    mdr_ctrl_out <= mdr_ctrl_lh after tpd_dec;
          when rr_func_lb  =>
	    dec2_out <= load_b_1 after tpd_dec;
	    mdr_ctrl_out <= mdr_ctrl_lb after tpd_dec;
          when rr_func_sw =>
	    dec2_out <= store_w_1 after tpd_dec;
	    mdr_ctrl_out <= mdr_ctrl_none after tpd_dec;
          when rr_func_sh =>
	    dec2_out <= store_h_1 after tpd_dec;
	    mdr_ctrl_out <= mdr_ctrl_sh after tpd_dec;
          when others =>                           -- illegal and other states
	    dec2_out <= store_b_1 after tpd_dec;   --  decoded in decoder_1
	    mdr_ctrl_out <= mdr_ctrl_sb after tpd_dec;
        end case; 
      when op_lw_i =>
	dec2_out <= load_w_1 after tpd_dec;
        mdr_ctrl_out <= mdr_ctrl_none after tpd_dec;
      when op_lh_i =>
	dec2_out <= load_h_1 after tpd_dec;
        mdr_ctrl_out <= mdr_ctrl_lh after tpd_dec;
      when op_lb_i  =>
	dec2_out <= load_b_1 after tpd_dec;
        mdr_ctrl_out <= mdr_ctrl_lb after tpd_dec;
      when op_sw_i =>
	dec2_out <= store_w_1 after tpd_dec;
        mdr_ctrl_out <= mdr_ctrl_none after tpd_dec;
      when op_sh_i =>
	dec2_out <= store_h_1 after tpd_dec;
        mdr_ctrl_out <= mdr_ctrl_sh after tpd_dec;
      when others =>                               -- illegal and other states
	dec2_out <= store_b_1 after tpd_dec;       --  decoded in decoder_1
        mdr_ctrl_out <= mdr_ctrl_sb after tpd_dec;
    end case;
  end process decode_2;    

end behaviour;


