--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--   Dataflow architecture for ICR register (32-bit)
--   with one tri-state output ond
--   additional bit load function for ICR(26 to 31)
--
--  (file icr-dataflow.vhd)
--------------------------------------------------------------------------

architecture dataflow of icr is
  signal icr_value : dlx_word;
begin
  --
  -- S bit
  --
  s_bit : process(s_en, latch_en, d)
  begin
    if s_en = '0' then
      icr_value(31) <=  '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(31) <= To_UX01(d(31)) after tpd_latch;
    end if;      
  end process;
  --
  -- exception bits
  --
  ioc_bit : process(ioc_en, latch_en, d)
  begin
    if ioc_en = '0' then
      icr_value(30) <=  '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(30) <= To_UX01(d(30)) after tpd_latch;
    end if;      
  end process;

  irra_bit : process(irra_en, latch_en, d)
  begin
    if irra_en = '0' then
      icr_value(29) <=  '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(29) <= To_UX01(d(29)) after tpd_latch;
    end if;      
  end process;

  iav_bit : process(iav_en, latch_en, d)
  begin
    if iav_en = '0' then
      icr_value(28) <=  '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(28) <= To_UX01(d(28)) after tpd_latch;
    end if;      
  end process;

  dav_bit : process(dav_en, latch_en, d)
  begin
    if dav_en = '0' then
      icr_value(27) <=  '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(27) <= To_UX01(d(27)) after tpd_latch;
    end if;      
  end process;

  ovad_bit : process(ovad_en, latch_en, d)
  begin
    if ovad_en = '0' then
      icr_value(26) <=  '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(26) <= To_UX01(d(26)) after tpd_latch;
    end if;
  end process;

  ovar_bit : process(ovar_en, latch_en, d)
  begin
    if ovar_en = '0' then
      icr_value(25) <=  '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(25) <= To_UX01(d(25)) after tpd_latch;
    end if;
  end process;

  priv_bit : process(priv_en, latch_en, d)
  begin
    if priv_en = '0' then
      icr_value(24) <=  '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(24) <= To_UX01(d(24)) after tpd_latch;
    end if;      
  end process;
  
  --
  -- interrupt bits
  --
  intrpt0_bit : process(intrpt_in(0), intrpt_en, latch_en, d)
  begin
    if intrpt_in(0) = '1' and intrpt_en = '1' then
      icr_value(16) <= '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(16) <= To_UX01(d(16)) after tpd_latch;
    end if;
  end process;

  intrpt1_bit : process(intrpt_in(1), intrpt_en, latch_en, d)
  begin
    if intrpt_in(1) = '1' and intrpt_en = '1' then
      icr_value(17) <= '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(17) <= To_UX01(d(17)) after tpd_latch;
    end if;
  end process;

  intrpt2_bit : process(intrpt_in(2), intrpt_en, latch_en, d)
  begin
    if intrpt_in(2) = '1' and intrpt_en = '1' then
      icr_value(18) <= '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(18) <= To_UX01(d(18)) after tpd_latch;
    end if;
  end process;

  intrpt3_bit : process(intrpt_in(3), intrpt_en, latch_en, d)
  begin
    if intrpt_in(3) = '1' and intrpt_en = '1' then
      icr_value(19) <= '1' after tpd_latch;
    elsif latch_en = '0' then
      icr_value(19) <= To_UX01(d(19)) after tpd_latch;
    end if;
  end process;
  
  --
  -- mask bits and saved information
  --
  other_bits : process(latch_en, d)
  begin
    if latch_en = '0' then
      icr_value(0 to 15) <=  To_UX01(d(0 to 15)) after tpd_latch;
      icr_value(20 to 23) <=  To_UX01(d(20 to 23)) after tpd_latch;
    end if;
  end process;

  --
  -- outputs
  --
  q <= icr_value after tpd_out when out_en = '0' else
       (others => 'Z') after tpd_out;

  intrpt <= (icr_value(16) and icr_value(20)) or
            (icr_value(17) and icr_value(21)) or
	    (icr_value(18) and icr_value(22)) or
	    (icr_value(19) and icr_value(23)) after tpd_out;

  super <= icr_value(31);  	    
end dataflow;

