--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for the finite state machine
--
--  file fsm.vhd
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

use WORK.dlx_types.all;
use WORK.control_types.all;

--synopsys synthesis_off
use STD.textio.all;
--synopsys synthesis_on

entity fsm is 
  generic (tpd_fsm : Time;                            -- fsm / decoder or gate
           DEBUG : boolean := false);

  port (phi1 : in std_logic;                          -- phase one of clock
      	reset : in std_logic;                         -- reset input
	halt  : in std_logic;                         -- halt input
	ready : in std_logic;                         -- mem. ready input
	alu_zero : in std_logic;                      -- alu zero bit
	alu_neg  : in std_logic;                      -- alu negative bit
	alu_ovfl : in std_logic;                      -- alu overflow bit
	intrpt   : in std_logic;                      -- interrupt active
	super    : in std_logic;                      -- supervisor bit input
	priv_ins : in std_logic;                      -- priviledged instr flag
	dec_1_in : in fsm_states;                     -- input from instr. dec. 1
	dec_2_in : in fsm_states;                     -- input from instr. dec. 2
	adr_msb  : in std_logic;                      -- most significant adr. bit 
	adr_ls2  : in std_logic_vector(1 downto 0);   -- least sign. 2 adr. bits
	s1_enab    : out std_logic_vector(0 to 7);    -- select s1 source
	s2_enab    : out std_logic_vector(0 to 5);    -- select s2_source
	dest_enab  : out std_logic_vector(0 to 7);    -- select destination
	alu_op_sel : out std_logic_vector(0 to 3);    -- alu operation
	const_sel  : out std_logic_vector(0 to 1);    -- select const for s1
	rf_op_sel  : out std_logic_vector(0 to 2);    -- select reg file op.
	immed_sel  : out std_logic_vector(0 to 1);    -- select immed. from ir
	exc_enab   : out std_logic_vector(0 to 7);    -- enable set exc. bit
	mem_ctrl   : out std_logic_vector(0 to 8));   -- memory control lines
end fsm;


