--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Package for the data types used in dlx description
--  
--  (file dlx_types.vhd)
--------------------------------------------------------------------------

library IEEE;
USE IEEE.std_logic_1164.ALL;

package dlx_types is
  
  subtype dlx_word is std_logic_vector(0 to 31);  	-- bit 0 is msb
  subtype dlx_half is std_logic_vector(0 to 15);	-- bit 0 is msb
  subtype dlx_byte is std_logic_vector(0 to 7);         -- bit 0 is msb
  subtype dlx_nibble is std_logic_vector(0 to 3); 	-- bit 0 is msb

  type dlx_word_array is array (natural range<>) of dlx_word;
 
  type mem_access_type is (word, half, byte);

  subtype dlx_address is std_logic_vector(31 downto 0);	    -- bit 31 is msb
  subtype dlx_halfaddress is std_logic_vector(15 downto 0); -- bit 15 is msb  

  subtype dlx_opcode  is std_logic_vector(0 to 5);
  subtype dlx_rr_func is std_logic_vector(0 to 5);
  subtype dlx_fp_func is std_logic_vector(0 to 4);
  subtype dlx_reg_addr is std_logic_vector(0 to 4);
  subtype dlx_immed16 is std_logic_vector(0 to 15);
  subtype dlx_immed26 is std_logic_vector(0 to 25);
  
  subtype reg_index is natural range 0 to 31;
  constant link_reg : reg_index := 31;

end dlx_types;


