--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Configuration for the DLX 
--  
--  (file dlx_config-rtl_1.vhd)
--------------------------------------------------------------------------

configuration dlx_config_rtl_1 OF dlx IS

  for structural

    for the_core : core
      use entity WORK.core(structural);

      for structural

	for the_datapath : datapath
          USE configuration WORK.datapath_config1;
	end for; -- the_datapath

	for the_controller : controller
          USE configuration WORK.controller_config1;
	end for; -- the_controller

      end for; -- core-structural

    end for; --the_core

    --
    -- configuration of the pads
    --
    for all : pad_out
      use entity WORK.pad_out(dataflow)
        generic map (tpd_c2p => 1 ns,
 	             t_enab  => 1 ns);
    end for; -- pad_out

    for all : pad_in
      use entity WORK.pad_in(dataflow)
        generic map (tpd_p2c => 1 ns);
    end for; -- pad_in

    for interrupt_pads(0 to 3)
      for intrpt_pad : pad_in
        use entity WORK.pad_in(dataflow)
          generic map (tpd_p2c => 1 ns);
      end for; -- intrpt_pad
    end for; -- interrupt_pads;
	
    for data_pads(0 to 31)
      for d_pad : pad_io
        use entity WORK.pad_io(dataflow)
          generic map (tpd_c2p => 1 ns,
	               tpd_p2c => 1 ns,
 	               t_switch  => 1 ns);
      end for; -- d_pad
    end for; -- data_pads
	
    for address_pads(0 to 31)
      for a_pad : pad_out    
        use entity WORK.pad_out(dataflow)
          generic map (tpd_c2p => 1 ns,
 	               t_enab  => 1 ns);
      end for; -- a_pad
    end for; -- address_pads

    for enable_pads(0 to 3)
      for en_pad : pad_out    
        use entity WORK.pad_out(dataflow)
          generic map (tpd_c2p => 1 ns,
 	               t_enab  => 1 ns);
      end for; -- en_pad
    end for; -- enable_pads
    
  end for; -- dlx_structural

end dlx_config_rtl_1;
