--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  entity declaration of the DLX processor core  
--  
--  (file core.vhd)
--------------------------------------------------------------------------

library IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.dlx_types.all;

entity core is
  port (a_bus  : out dlx_address;
       	d_bus_in  : in dlx_word;
	d_bus_out : out dlx_word;
        enable : out dlx_nibble;
	rw     : out std_logic;
	error  : out std_logic;
	ready  : in std_logic;
	reset  : in std_logic;             -- asynchronous reset 
	halt   : in std_logic;             -- freeze of processor state
	intrpt : in dlx_nibble;            -- interupt signals (maskable)
        phi1   : in std_logic;             -- 2 phase non overlapping clock
	phi2   : in std_logic;
	pad_out_en : out std_logic;        -- output pads enable (0 = out, 1 = tri)
	pad_io_sw  : out std_logic);       -- io pads switch (0 = output, 1 = input)

end core;

