--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--   Dataflow architecture for 32 bit bus constant
--
--  (file bus_const32-dataflow.vhd)
--------------------------------------------------------------------------

architecture dataflow of bus_const32 is
  signal tmp1, tmp2 : dlx_word;
begin
  tmp1 <= To_StdLogicVector(X"0000_0000") when sel = "00" else   -- 0
          To_StdLogicVector(X"0000_0001") when sel = "01" else   -- 1
          To_StdLogicVector(X"0000_0004");                       -- 4
	  
  tmp2 <= To_StdLogicVector(X"0000_0000") when sel = "00" else   -- 0
          To_StdLogicVector(X"0000_0010") when sel = "01" else   -- 16
          To_StdLogicVector(X"0000_0018");                       -- 24

  q1 <= tmp1 after tpd_out when out_en1 = '0' else
        "ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ" after tpd_out;
  q2 <= tmp2 after tpd_out when out_en2 = '0' else
        "ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ" after tpd_out;
end dataflow;




