--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for the ALU
--
--  (file alu.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- alu functions:
--
-- func(0 to 3) => "00_-0" pass S1
--                 "00_-1" pass S2
--                 "01_-0" S1 + S2 (signed addition)
--                 "01_-1" S1 - S2 (signed subtraction)
--                 "10_00" sll S1 by <S2>
--                 "10_01" srl S1 by <S2>
--                 "10_1-" sra S1 by <S2>
--                 "11_00" S1 and S2
--                 "11_01" S1 or S2
--                 "11_1-" S1 xor S2
--------------------------------------------------------------------------
--  latch_en : low active
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

library IEEE_EXTD;
use IEEE_EXTD.stdl1164_vector_arithmetic.all;

use WORK.dlx_types.all;

entity alu is
  generic (tpd_latch, tpd_out : Time);
           -- := 0 ns for LF configuration
  port (s1       : in dlx_word;
      	s2       : in dlx_word;
        latch_en : in std_logic;
	result   : out dlx_word;
	func     : in dlx_nibble;
	zero     : out std_logic;
	negative : out std_logic;
	overflow : out std_logic);
end alu;

